/*
 * Decompiled with CFR 0.152.
 */
package org.appops.tsgen.jackson.module.grammar;

import java.io.IOException;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.Map;
import org.appops.tsgen.jackson.module.grammar.FunctionType;
import org.appops.tsgen.jackson.module.grammar.base.AbstractNamedType;
import org.appops.tsgen.jackson.module.grammar.base.AbstractType;
import org.appops.tsgen.jackson.module.writer.WriterPreferences;

public class ClassType
extends AbstractNamedType {
    private Map<String, AbstractType> fields = new LinkedHashMap<String, AbstractType>();
    private Map<String, FunctionType> methods = new LinkedHashMap<String, FunctionType>();
    private static ClassType objectType = new ClassType("Object");

    public static ClassType getObjectClass() {
        return objectType;
    }

    public ClassType(String className) {
        super(className);
    }

    @Override
    public void writeDefInternal(Writer writer, WriterPreferences preferences) throws IOException {
        writer.write(String.format("interface %s {\n", this.name));
        preferences.increaseIndentation();
        for (Map.Entry<String, AbstractType> entry : this.fields.entrySet()) {
            writer.write(String.format("%s%s: ", preferences.getIndentation(), entry.getKey()));
            entry.getValue().write(writer);
            writer.write(";\n");
        }
        for (String methodName : this.methods.keySet()) {
            writer.write(preferences.getIndentation() + methodName);
            this.methods.get(methodName).writeNonLambda(writer);
            writer.write(";\n");
        }
        preferences.decreaseIndention();
        writer.write(preferences.getIndentation() + "}");
    }

    public Map<String, AbstractType> getFields() {
        return this.fields;
    }

    public void setFields(Map<String, AbstractType> fields) {
        this.fields = fields;
    }

    public Map<String, FunctionType> getMethods() {
        return this.methods;
    }
}

