/*
 * Decompiled with CFR 0.152.
 */
package org.appops.tsgen.jackson.module.grammar;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.appops.tsgen.jackson.module.grammar.base.AbstractNamedType;
import org.appops.tsgen.jackson.module.writer.WriterPreferences;

public class EnumType
extends AbstractNamedType {
    private List<String> values = new ArrayList<String>();

    public EnumType(String className) {
        super(className);
    }

    @Override
    public void writeDefInternal(Writer writer, WriterPreferences preferences) throws IOException {
        writer.write(String.format("enum %s {\n", this.name));
        preferences.increaseIndentation();
        for (String value : this.values) {
            writer.write(String.format("%s%s,\n", preferences.getIndentation(), value));
        }
        preferences.decreaseIndention();
        writer.write(preferences.getIndentation() + "}");
    }

    public List<String> getValues() {
        return this.values;
    }

    public void setValues(List<String> values) {
        this.values = values;
    }
}

