/*
 * Decompiled with CFR 0.152.
 */
package org.appops.tsgen.jackson.module.grammar;

import java.io.IOException;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.Map;
import org.appops.tsgen.jackson.module.grammar.base.AbstractType;

public class FunctionType
extends AbstractType {
    private LinkedHashMap<String, AbstractType> parameters = new LinkedHashMap();
    private AbstractType resultType;

    @Override
    public void write(Writer writer) throws IOException {
        this.write(writer, true);
    }

    private void write(Writer writer, boolean lambdaSyntax) throws IOException {
        writer.write("(");
        int i = 1;
        for (Map.Entry<String, AbstractType> entry : this.parameters.entrySet()) {
            writer.write(entry.getKey());
            writer.write(": ");
            entry.getValue().write(writer);
            if (i < this.parameters.size()) {
                writer.write(", ");
            }
            ++i;
        }
        writer.write(")" + (lambdaSyntax ? "=> " : ": "));
        this.resultType.write(writer);
    }

    public void writeNonLambda(Writer writer) throws IOException {
        this.write(writer, false);
    }

    public LinkedHashMap<String, AbstractType> getParameters() {
        return this.parameters;
    }

    public AbstractType getResultType() {
        return this.resultType;
    }

    public void setResultType(AbstractType resultType) {
        this.resultType = resultType;
    }
}

