/*
 * Decompiled with CFR 0.152.
 */
package org.appops.tsgen.jackson.module.visitors;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitable;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import org.appops.tsgen.jackson.module.Configuration;
import org.appops.tsgen.jackson.module.grammar.AnyType;
import org.appops.tsgen.jackson.module.grammar.ArrayType;
import org.appops.tsgen.jackson.module.grammar.BooleanType;
import org.appops.tsgen.jackson.module.grammar.NumberType;
import org.appops.tsgen.jackson.module.grammar.StringType;
import org.appops.tsgen.jackson.module.grammar.base.AbstractType;
import org.appops.tsgen.jackson.module.visitors.BaseTsJsonFormatVisitor;
import org.appops.tsgen.jackson.module.visitors.TsJsonFormatVisitorWrapper;

public class TsJsonArrayFormatVisitor
extends BaseTsJsonFormatVisitor<ArrayType>
implements JsonArrayFormatVisitor {
    public TsJsonArrayFormatVisitor(BaseTsJsonFormatVisitor parentHolder, Configuration conf) {
        super(parentHolder, conf);
        this.type = new ArrayType();
    }

    public void itemsFormat(JsonFormatVisitable handler, JavaType elementType) throws JsonMappingException {
        TsJsonFormatVisitorWrapper visitorWrapper = new TsJsonFormatVisitorWrapper(this, this.conf);
        handler.acceptJsonFormatVisitor((JsonFormatVisitorWrapper)visitorWrapper, elementType);
        ((ArrayType)this.type).setItemType((AbstractType)visitorWrapper.getType());
    }

    public void itemsFormat(JsonFormatTypes format) throws JsonMappingException {
        ((ArrayType)this.type).setItemType(TsJsonArrayFormatVisitor.typeScriptTypeFromJsonType(format));
    }

    private static AbstractType typeScriptTypeFromJsonType(JsonFormatTypes type) {
        switch (type) {
            case ANY: {
                return AnyType.getInstance();
            }
            case BOOLEAN: {
                return BooleanType.getInstance();
            }
            case ARRAY: {
                return new ArrayType(AnyType.getInstance());
            }
            case INTEGER: 
            case NUMBER: {
                return NumberType.getInstance();
            }
            case STRING: {
                return StringType.getInstance();
            }
        }
        throw new UnsupportedOperationException();
    }
}

