/*
 * Decompiled with CFR 0.152.
 */
package org.appops.tsgen.jackson.module.visitors;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonAnyFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonBooleanFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitable;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonIntegerFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonMapFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonNullFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonNumberFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonObjectFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonStringFormatVisitor;
import org.appops.tsgen.jackson.module.Configuration;
import org.appops.tsgen.jackson.module.grammar.ClassType;
import org.appops.tsgen.jackson.module.grammar.EnumType;
import org.appops.tsgen.jackson.module.grammar.Module;
import org.appops.tsgen.jackson.module.grammar.base.AbstractNamedType;
import org.appops.tsgen.jackson.module.grammar.base.AbstractType;
import org.appops.tsgen.jackson.module.visitors.BaseTsJsonFormatVisitor;
import org.appops.tsgen.jackson.module.visitors.TsJsonAnyFormatVisitor;
import org.appops.tsgen.jackson.module.visitors.TsJsonArrayFormatVisitor;
import org.appops.tsgen.jackson.module.visitors.TsJsonBooleanFormatVisitor;
import org.appops.tsgen.jackson.module.visitors.TsJsonMapFormatVisitor;
import org.appops.tsgen.jackson.module.visitors.TsJsonNullFormatVisitor;
import org.appops.tsgen.jackson.module.visitors.TsJsonNumberFormatVisitor;
import org.appops.tsgen.jackson.module.visitors.TsJsonObjectFormatVisitor;
import org.appops.tsgen.jackson.module.visitors.TsJsonStringFormatVisitor;

public class TsJsonFormatVisitorWrapper
extends BaseTsJsonFormatVisitor
implements JsonFormatVisitorWrapper {
    public TsJsonFormatVisitorWrapper(BaseTsJsonFormatVisitor parentHolder, Configuration conf) {
        super(parentHolder, conf);
    }

    public TsJsonFormatVisitorWrapper(Module module, Configuration conf) {
        super(module, conf);
    }

    private <T extends BaseTsJsonFormatVisitor<?>> T setTypeAndReturn(T actualVisitor) {
        this.type = actualVisitor.getType();
        return actualVisitor;
    }

    public static AbstractType getTsTypeForHandler(BaseTsJsonFormatVisitor<?> baseVisitor, JsonFormatVisitable handler, JavaType typeHint, Configuration conf) throws JsonMappingException {
        AbstractType computedType = baseVisitor.getComputedTypes().get(typeHint);
        if (computedType != null) {
            return computedType;
        }
        TsJsonFormatVisitorWrapper visitor = new TsJsonFormatVisitorWrapper(baseVisitor, conf);
        handler.acceptJsonFormatVisitor((JsonFormatVisitorWrapper)visitor, typeHint);
        baseVisitor.getComputedTypes().put(typeHint, (AbstractType)visitor.getType());
        return visitor.getType();
    }

    public String getName(JavaType type) {
        return this.conf.getNamingStrategy().getName(type);
    }

    private TsJsonObjectFormatVisitor useNamedClassOrParse(JavaType javaType) {
        String name = this.getName(javaType);
        AbstractNamedType namedType = this.getModule().getNamedTypes().get(name);
        if (namedType == null) {
            TsJsonObjectFormatVisitor visitor = new TsJsonObjectFormatVisitor(this, name, javaType.getRawClass(), this.conf);
            this.type = visitor.getType();
            this.getModule().getNamedTypes().put(((ClassType)visitor.getType()).getName(), (AbstractNamedType)visitor.getType());
            visitor.addPublicMethods();
            return visitor;
        }
        this.type = namedType;
        return null;
    }

    public EnumType parseEnumOrGetFromCache(Module module, JavaType javaType) {
        String name = this.getName(javaType);
        AbstractType namedType = module.getNamedTypes().get(name);
        if (namedType == null) {
            EnumType enumType = new EnumType(name);
            for (Object val : javaType.getRawClass().getEnumConstants()) {
                enumType.getValues().add(val.toString());
            }
            module.getNamedTypes().put(name, enumType);
            return enumType;
        }
        return (EnumType)namedType;
    }

    public JsonObjectFormatVisitor expectObjectFormat(JavaType type) throws JsonMappingException {
        return this.useNamedClassOrParse(type);
    }

    public JsonArrayFormatVisitor expectArrayFormat(JavaType type) throws JsonMappingException {
        return this.setTypeAndReturn(new TsJsonArrayFormatVisitor(this, this.conf));
    }

    public JsonStringFormatVisitor expectStringFormat(JavaType jtype) throws JsonMappingException {
        if (jtype.getRawClass().isEnum()) {
            this.type = this.parseEnumOrGetFromCache(this.getModule(), jtype);
            return null;
        }
        return this.setTypeAndReturn(new TsJsonStringFormatVisitor(this, this.conf));
    }

    public JsonNumberFormatVisitor expectNumberFormat(JavaType type) throws JsonMappingException {
        return this.setTypeAndReturn(new TsJsonNumberFormatVisitor(this, this.conf));
    }

    public JsonIntegerFormatVisitor expectIntegerFormat(JavaType type) throws JsonMappingException {
        return this.setTypeAndReturn(new TsJsonNumberFormatVisitor(this, this.conf));
    }

    public JsonBooleanFormatVisitor expectBooleanFormat(JavaType type) throws JsonMappingException {
        return this.setTypeAndReturn(new TsJsonBooleanFormatVisitor(this, this.conf));
    }

    public JsonNullFormatVisitor expectNullFormat(JavaType type) throws JsonMappingException {
        return this.setTypeAndReturn(new TsJsonNullFormatVisitor(this, this.conf));
    }

    public JsonAnyFormatVisitor expectAnyFormat(JavaType type) throws JsonMappingException {
        if (Object.class.getCanonicalName().equals(type.getRawClass().getName())) {
            return this.setTypeAndReturn(new TsJsonAnyFormatVisitor(this, this.conf));
        }
        this.useNamedClassOrParse(type);
        return null;
    }

    public JsonMapFormatVisitor expectMapFormat(JavaType type) throws JsonMappingException {
        return this.setTypeAndReturn(new TsJsonMapFormatVisitor(this, this.conf));
    }
}

