/*
 * Decompiled with CFR 0.152.
 */
package org.appops.tsgen.jackson.module.visitors;

import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.PropertyMetadata;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import com.fasterxml.jackson.databind.introspect.AnnotationMap;
import com.fasterxml.jackson.databind.introspect.TypeResolutionContext;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitable;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonObjectFormatVisitor;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import org.appops.tsgen.jackson.module.Configuration;
import org.appops.tsgen.jackson.module.grammar.AnyType;
import org.appops.tsgen.jackson.module.grammar.ClassType;
import org.appops.tsgen.jackson.module.grammar.FunctionType;
import org.appops.tsgen.jackson.module.grammar.VoidType;
import org.appops.tsgen.jackson.module.grammar.base.AbstractType;
import org.appops.tsgen.jackson.module.visitors.BaseTsJsonFormatVisitor;
import org.appops.tsgen.jackson.module.visitors.TsJsonFormatVisitorWrapper;

public class TsJsonObjectFormatVisitor
extends BaseTsJsonFormatVisitor<ClassType>
implements JsonObjectFormatVisitor {
    private Class clazz;

    public TsJsonObjectFormatVisitor(BaseTsJsonFormatVisitor<?> parentHolder, String className, Class clazz, Configuration conf) {
        super(parentHolder, conf);
        this.type = new ClassType(className);
        this.clazz = clazz;
    }

    private void addField(String name, AbstractType fieldType) {
        ((ClassType)this.type).getFields().put(name, fieldType);
    }

    private boolean isAccessorMethod(Method method, BeanInfo beanInfo) {
        for (PropertyDescriptor property : beanInfo.getPropertyDescriptors()) {
            if (method.equals(property.getReadMethod())) {
                return true;
            }
            if (!method.equals(property.getWriteMethod())) continue;
            return true;
        }
        return false;
    }

    void addPublicMethods() {
        for (Method method : this.clazz.getDeclaredMethods()) {
            if (!Modifier.isPublic(method.getModifiers())) continue;
            try {
                BeanInfo beanInfo = Introspector.getBeanInfo(this.clazz);
                if (this.isAccessorMethod(method, beanInfo)) {
                    continue;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (this.conf.isIgnoredMethod(method)) continue;
            this.addMethod(method);
        }
    }

    private AbstractType getTsTypeForClass(AnnotatedMember member) {
        BeanProperty.Std prop = new BeanProperty.Std(new PropertyName(member.getName()), member.getType(), PropertyName.NO_NAME, member, PropertyMetadata.STD_OPTIONAL);
        try {
            return this.getTsTypeForProperty((BeanProperty)prop);
        }
        catch (JsonMappingException e) {
            throw new RuntimeException(e);
        }
    }

    private void addMethod(Method method) {
        FunctionType function = new FunctionType();
        JavaType type = TypeFactory.defaultInstance().constructType((Type)this.clazz);
        TypeResolutionContext.Basic typeResolutionContext = new TypeResolutionContext.Basic(TypeFactory.defaultInstance(), type.getBindings());
        AnnotatedMethod annotMethod = new AnnotatedMethod((TypeResolutionContext)typeResolutionContext, method, new AnnotationMap(), null);
        Parameter[] parameters = method.getParameters();
        function.setResultType(this.getTsTypeForClass((AnnotatedMember)annotMethod));
        for (int i = 0; i < annotMethod.getParameterCount(); ++i) {
            AnnotatedParameter param = annotMethod.getParameter(i);
            String name = parameters[i].getName();
            function.getParameters().put(name, this.getTsTypeForClass((AnnotatedMember)param));
        }
        ((ClassType)this.type).getMethods().put(method.getName(), function);
    }

    public void property(BeanProperty writer) throws JsonMappingException {
        this.addField(writer.getName(), this.getTsTypeForProperty(writer));
    }

    public void property(String name, JsonFormatVisitable handler, JavaType propertyTypeHint) throws JsonMappingException {
        this.addField(name, TsJsonFormatVisitorWrapper.getTsTypeForHandler(this, handler, propertyTypeHint, this.conf));
    }

    public void optionalProperty(BeanProperty writer) throws JsonMappingException {
        this.addField(writer.getName(), this.getTsTypeForProperty(writer));
    }

    public void optionalProperty(String name, JsonFormatVisitable handler, JavaType propertyTypeHint) throws JsonMappingException {
        this.addField(name, TsJsonFormatVisitorWrapper.getTsTypeForHandler(this, handler, propertyTypeHint, this.conf));
    }

    protected AbstractType getTsTypeForProperty(BeanProperty writer) throws JsonMappingException {
        if (writer == null) {
            throw new IllegalArgumentException("Null writer");
        }
        JavaType type = writer.getType();
        if (type.getRawClass().equals(Void.TYPE)) {
            return VoidType.getInstance();
        }
        AbstractType customType = this.conf.getCustomTypes().get(type.getRawClass().getName());
        if (customType != null) {
            return customType;
        }
        try {
            JsonSerializer<Object> ser = this.getSer(writer);
            if (ser != null) {
                if (type == null) {
                    throw new IllegalStateException("Missing type for property '" + writer.getName() + "'");
                }
                return TsJsonFormatVisitorWrapper.getTsTypeForHandler(this, ser, type, this.conf);
            }
            return AnyType.getInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Error when serializing %s, you should add a custom mapping for it", type.getRawClass()), e);
        }
    }

    protected JsonSerializer<Object> getSer(BeanProperty writer) throws JsonMappingException {
        JsonSerializer ser = null;
        if (writer instanceof BeanPropertyWriter) {
            ser = ((BeanPropertyWriter)writer).getSerializer();
        }
        if (ser == null) {
            ser = this.getProvider().findValueSerializer(writer.getType(), writer);
        }
        return ser;
    }
}

