/*
 * Decompiled with CFR 0.152.
 */
package org.appops.tsgen.jackson.module.writer;

import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Map;
import org.appops.tsgen.jackson.module.grammar.EnumType;
import org.appops.tsgen.jackson.module.grammar.Module;
import org.appops.tsgen.jackson.module.grammar.base.AbstractNamedType;
import org.appops.tsgen.jackson.module.grammar.base.AbstractType;
import org.appops.tsgen.jackson.module.writer.ModuleWriter;
import org.appops.tsgen.jackson.module.writer.WriterPreferences;

public class ExternalModuleFormatWriter
implements ModuleWriter {
    public WriterPreferences preferences = new WriterPreferences();

    @Override
    public void write(Module module, Writer writer) throws IOException {
        this.writeModuleContent(module, writer);
        writer.flush();
    }

    protected void writeModuleContent(Module module, Writer writer) throws IOException {
        Collection<AbstractNamedType> namedTypes = module.getNamedTypes().values();
        this.writeEnumPatternBaseClassIfNeeded(namedTypes, writer);
        for (AbstractNamedType abstractNamedType : namedTypes) {
            writer.write(this.preferences.getIndentation() + "export ");
            abstractNamedType.writeDef(writer, this.preferences);
            writer.write("\n\n");
        }
        for (Map.Entry entry : module.getVars().entrySet()) {
            writer.write(this.preferences.getIndentation() + "export var " + (String)entry.getKey() + ": ");
            ((AbstractType)entry.getValue()).write(writer);
            writer.write(";\n");
        }
    }

    private void writeEnumPatternBaseClassIfNeeded(Collection<AbstractNamedType> namedTypes, Writer writer) throws IOException {
        if (this.preferences.isUseEnumPattern() && this.hasEnum(namedTypes)) {
            this.writeBaseEnum(writer);
            writer.write("\n");
        }
    }

    private boolean hasEnum(Collection<AbstractNamedType> namedTypes) {
        for (AbstractNamedType type : namedTypes) {
            if (!(type instanceof EnumType)) continue;
            return true;
        }
        return false;
    }

    private void writeBaseEnum(Writer writer) throws IOException {
        writer.write(this.preferences.getIndentation() + "/** base class for implementing enums with Typesafe Enum Pattern (to be able to use enum names, instead of ordinal values, in a type-safe manner) */\n");
        writer.write(this.preferences.getIndentation() + "export class EnumPatternBase {\n");
        this.preferences.increaseIndentation();
        writer.write(this.preferences.getIndentation() + "constructor(public name: string){}\n");
        writer.write(this.preferences.getIndentation() + "toString(){ return this.name; }\n");
        this.preferences.decreaseIndention();
        writer.write(this.preferences.getIndentation() + "}\n");
    }
}

