/*
 * AppOps is a Java framework to develop, deploy microservices with ease and is available for free
 * and common use developed by AinoSoft ( www.ainosoft.com )
 *
 * AppOps and AinoSoft are registered trademarks of Aino Softwares private limited, India.
 *
 * Copyright (C) <2016> <Aino Softwares private limited>
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the
 * GNU General Public License as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version along with applicable additional terms as
 * provisioned by GPL 3.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License and applicable additional terms
 * along with this program.
 *
 * If not, see <https://www.gnu.org/licenses/> and <https://www.appops.org/license>
 */

package org.appops.tsgen.jackson.module.grammar;

import static java.lang.String.format;

//
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.appops.tsgen.jackson.module.grammar.base.AbstractNamedType;
import org.appops.tsgen.jackson.module.writer.WriterPreferences;

public class EnumType extends AbstractNamedType {

  private List<String> values = new ArrayList<String>();

  public EnumType(String className) {
    super(className);
  }

  @Override
  public void writeDefInternal(Writer writer, WriterPreferences preferences) throws IOException {
    writer.write(format("enum %s {\n", name));
    preferences.increaseIndentation();
    for (String value : values) {
      writer.write(format("%s%s,\n", preferences.getIndentation(), value));
    }
    preferences.decreaseIndention();
    writer.write(preferences.getIndentation() + "}");
  }

  public List<String> getValues() {
    return values;
  }

  public void setValues(List<String> values) {
    this.values = values;
  }

}
