/*
 * AppOps is a Java framework to develop, deploy microservices with ease and is available for free
 * and common use developed by AinoSoft ( www.ainosoft.com )
 *
 * AppOps and AinoSoft are registered trademarks of Aino Softwares private limited, India.
 *
 * Copyright (C) <2016> <Aino Softwares private limited>
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the
 * GNU General Public License as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version along with applicable additional terms as
 * provisioned by GPL 3.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License and applicable additional terms
 * along with this program.
 *
 * If not, see <https://www.gnu.org/licenses/> and <https://www.appops.org/license>
 */

package org.appops.tsgen.jackson.module.visitors;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWithSerializerProvider;
import java.util.HashMap;
import java.util.Map;
import org.appops.tsgen.jackson.module.Configuration;
import org.appops.tsgen.jackson.module.grammar.Module;
import org.appops.tsgen.jackson.module.grammar.base.AbstractType;

/**
 * Chained providers with a root parent holder keeping a map of already computed types.
 */
public abstract class BaseTsJsonFormatVisitor<T extends AbstractType>
    implements JsonFormatVisitorWithSerializerProvider {

  private final BaseTsJsonFormatVisitor<?> parentHolder;

  protected T type;

  private SerializerProvider serializerProvider;

  private Module module;

  private Map<JavaType, AbstractType> computedTypes;

  protected final Configuration conf;

  public BaseTsJsonFormatVisitor(BaseTsJsonFormatVisitor parentHolder, Configuration conf) {
    this.parentHolder = parentHolder;
    this.conf = conf;
  }

  /**
   * Object constructor.
   * 
   * @param module Ts module.
   * @param conf Export configuration.
   */
  public BaseTsJsonFormatVisitor(Module module, Configuration conf) {
    this.parentHolder = null;
    this.module = module;
    this.conf = conf;
  }

  public SerializerProvider getProvider() {
    return (parentHolder == null) ? serializerProvider : parentHolder.getProvider();
  }

  /**
   * Sets provider for serializer.
   * 
   * @param provider Custom serializer provider.
   */
  public void setProvider(SerializerProvider provider) {
    if (parentHolder != null) {
      parentHolder.setProvider(provider);
    } else {
      serializerProvider = provider;
    }
  }

  /**
   * Fetches typescript module.
   * 
   * @return Appropriate typescript module fetched.
   */
  public Module getModule() {
    if (parentHolder == null) {
      return module;
    } else {
      return parentHolder.getModule();
    }
  }

  /**
   * Fetches computed types.
   * 
   * @return Map of computed types obtained while exporting.
   */
  public Map<JavaType, AbstractType> getComputedTypes() {
    if (parentHolder == null) {
      if (computedTypes == null) {
        computedTypes = new HashMap<JavaType, AbstractType>();
      }
      return computedTypes;
    } else {
      return parentHolder.getComputedTypes();
    }
  }

  public T getType() {
    return type;
  }
}
