/*
 * AppOps is a Java framework to develop, deploy microservices with ease and is available for free
 * and common use developed by AinoSoft ( www.ainosoft.com )
 *
 * AppOps and AinoSoft are registered trademarks of Aino Softwares private limited, India.
 *
 * Copyright (C) <2016> <Aino Softwares private limited>
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the
 * GNU General Public License as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version along with applicable additional terms as
 * provisioned by GPL 3.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License and applicable additional terms
 * along with this program.
 *
 * If not, see <https://www.gnu.org/licenses/> and <https://www.appops.org/license>
 */

package org.appops.tsgen.jackson.module.grammar;

import java.io.IOException;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.Map.Entry;
import org.appops.tsgen.jackson.module.grammar.base.AbstractType;

public class FunctionType extends AbstractType {

  private LinkedHashMap<String, AbstractType> parameters =
      new LinkedHashMap<String, AbstractType>();

  private AbstractType resultType;

  @Override
  public void write(Writer writer) throws IOException {
    write(writer, true);
  }


  /**
   * Write as func(a:string) : string.
   * 
   * @param writer java writer.
   * @param lambdaSyntax Boolean flag, true if passed functions is of lambda syntax.
   * @throws IOException if occured while writing typescript output.
   */
  private void write(Writer writer, boolean lambdaSyntax) throws IOException {
    writer.write("(");
    int i = 1;
    for (Entry<String, AbstractType> entry : parameters.entrySet()) {
      writer.write(entry.getKey());
      writer.write(": ");
      entry.getValue().write(writer);
      if (i < parameters.size()) {
        writer.write(", ");
      }
      i++;
    }
    writer.write(")" + (lambdaSyntax ? "=> " : ": "));
    resultType.write(writer);
  }

  /**
   * Write as non lambda : func(a:string) : string.
   * 
   * @param writer java writer.
   * @throws IOException if occured while writing typescript output.
   */
  public void writeNonLambda(Writer writer) throws IOException {
    write(writer, false);
  }



  public LinkedHashMap<String, AbstractType> getParameters() {
    return parameters;
  }

  public AbstractType getResultType() {
    return resultType;
  }

  public void setResultType(AbstractType resultType) {
    this.resultType = resultType;
  }

}
