/*
 * AppOps is a Java framework to develop, deploy microservices with ease and is available for free
 * and common use developed by AinoSoft ( www.ainosoft.com )
 *
 * AppOps and AinoSoft are registered trademarks of Aino Softwares private limited, India.
 *
 * Copyright (C) <2016> <Aino Softwares private limited>
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the
 * GNU General Public License as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version along with applicable additional terms as
 * provisioned by GPL 3.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License and applicable additional terms
 * along with this program.
 *
 * If not, see <https://www.gnu.org/licenses/> and <https://www.appops.org/license>
 */

package org.appops.tsgen.jackson.module.visitors;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitable;
import org.appops.tsgen.jackson.module.Configuration;
import org.appops.tsgen.jackson.module.grammar.AnyType;
import org.appops.tsgen.jackson.module.grammar.ArrayType;
import org.appops.tsgen.jackson.module.grammar.BooleanType;
import org.appops.tsgen.jackson.module.grammar.NumberType;
import org.appops.tsgen.jackson.module.grammar.StringType;
import org.appops.tsgen.jackson.module.grammar.base.AbstractType;

public class TsJsonArrayFormatVisitor extends BaseTsJsonFormatVisitor<ArrayType>
    implements JsonArrayFormatVisitor {

  public TsJsonArrayFormatVisitor(BaseTsJsonFormatVisitor parentHolder, Configuration conf) {
    super(parentHolder, conf);
    type = new ArrayType();
  }

  /**
   * Formatter method to format typescript output.
   * 
   * @param handler Json based type format handler.
   * @param elementType Java element type.
   */
  public void itemsFormat(JsonFormatVisitable handler, JavaType elementType)
      throws JsonMappingException {
    TsJsonFormatVisitorWrapper visitorWrapper = new TsJsonFormatVisitorWrapper(this, conf);
    handler.acceptJsonFormatVisitor(visitorWrapper, elementType);
    type.setItemType(visitorWrapper.getType());
  }

  public void itemsFormat(JsonFormatTypes format) throws JsonMappingException {
    type.setItemType(typeScriptTypeFromJsonType(format));
  }

  /**
   * Obtains typescript equivalent for json type passed.
   * 
   * @param type Json type.
   * @return Appropriate typescript equivalent.
   */
  private static AbstractType typeScriptTypeFromJsonType(JsonFormatTypes type) {
    switch (type) {
      case ANY:
        return AnyType.getInstance();
      case BOOLEAN:
        return BooleanType.getInstance();
      case ARRAY:
        return new ArrayType(AnyType.getInstance());
      case INTEGER: //$FALL-THROUGH$
      case NUMBER:
        return NumberType.getInstance();
      case STRING:
        return StringType.getInstance();
      default:
        throw new UnsupportedOperationException();
    }
  }
}
