/*
 * AppOps is a Java framework to develop, deploy microservices with ease and is available for free
 * and common use developed by AinoSoft ( www.ainosoft.com )
 *
 * AppOps and AinoSoft are registered trademarks of Aino Softwares private limited, India.
 *
 * Copyright (C) <2016> <Aino Softwares private limited>
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the
 * GNU General Public License as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version along with applicable additional terms as
 * provisioned by GPL 3.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License and applicable additional terms
 * along with this program.
 *
 * If not, see <https://www.gnu.org/licenses/> and <https://www.appops.org/license>
 */

package org.appops.tsgen.jackson.module.writer;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.appops.tsgen.jackson.module.grammar.base.AbstractNamedType;

/**
 * Typescript writer configuration details.
 */
public class WriterPreferences {
  private String indentationStep = "    ";
  private int indentationLevel = 0;

  private List<CustomAbstractTypeWriter> customWriters = new ArrayList<CustomAbstractTypeWriter>();
  private boolean useEnumPattern;

  public void useEnumPattern() {
    addWriter(new EnumTypeToEnumPatternWriter());
    useEnumPattern = true;
  }

  public boolean isUseEnumPattern() {
    return useEnumPattern;
  }

  public void addWriter(CustomAbstractTypeWriter writer) {
    this.customWriters.add(writer);
  }

  public List<CustomAbstractTypeWriter> getCustomWriters() {
    return customWriters;
  }

  public boolean hasCustomWriter(AbstractNamedType type) {
    return getCustomWriter(type) != null;
  }

  public void writeDef(AbstractNamedType type, Writer writer) throws IOException {
    getCustomWriter(type).writeDef(type, writer, this);
  }

  /**
   * Fetches custon type writer.
   * 
   * @param type Type for which writer is to be fetched.
   * @return Appropriate writer for type passed.
   */
  public CustomAbstractTypeWriter getCustomWriter(AbstractNamedType type) {
    for (CustomAbstractTypeWriter writer : customWriters) {
      if (writer.accepts(type, this)) {
        return writer;
      }
    }
    return null;
  }

  /**
   * Fetches indentations string.
   * 
   * @return Indentation string.
   */
  public String getIndentation() {
    StringBuilder sb = new StringBuilder();
    int i = 0;
    while (i++ < indentationLevel) {
      sb.append(indentationStep);
    }
    return sb.toString();
  }

  public void setIndentationStep(String indentation) {
    this.indentationStep = indentation;
  }

  public void increaseIndentation() {
    indentationLevel++;
  }

  public void decreaseIndention() {
    indentationLevel--;
  }

}
