/*
 * Decompiled with CFR 0.152.
 */
package org.appops.tsgen.jackson.module;

import java.beans.Transient;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.appops.tsgen.jackson.module.conf.typename.SimpleJacksonTsTypeNamingStrategy;
import org.appops.tsgen.jackson.module.conf.typename.TsTypeNamingStrategy;
import org.appops.tsgen.jackson.module.grammar.ArrayType;
import org.appops.tsgen.jackson.module.grammar.base.AbstractType;

public class Configuration {
    private Map<String, AbstractType> customTypes = Collections.emptyMap();
    private List<String> ignoredMethodNames = new ArrayList<String>();
    private TsTypeNamingStrategy namingStrategy = new SimpleJacksonTsTypeNamingStrategy();

    public Map<String, AbstractType> getCustomTypes() {
        return this.customTypes;
    }

    public Configuration addType(Class<?> klass, AbstractType tsType) {
        this.addType(klass.getName(), tsType);
        this.addArrayType(klass, tsType);
        return this;
    }

    public void addType(String className, AbstractType tsType) {
        HashMap<String, AbstractType> tmp = new HashMap<String, AbstractType>();
        tmp.putAll(this.customTypes);
        tmp.put(className, tsType);
        this.customTypes = Collections.unmodifiableMap(tmp);
    }

    public void addArrayType(Class<?> klass, AbstractType tsType) {
        this.addType("[L" + klass.getName() + ";", (AbstractType)new ArrayType(tsType));
    }

    public void addIngoredMethod(String name) {
        this.ignoredMethodNames.add(name);
    }

    public boolean isIgnoredMethod(Method method) {
        if (method.getAnnotation(Transient.class) != null) {
            return true;
        }
        return this.isIgnoredMethod(method.getName());
    }

    private boolean isIgnoredMethod(String name) {
        return this.ignoredMethodNames.contains(name);
    }

    public TsTypeNamingStrategy getNamingStrategy() {
        return this.namingStrategy;
    }

    public void setNamingStrategy(TsTypeNamingStrategy namingStrategy) {
        this.namingStrategy = namingStrategy;
    }
}

