/*
 * Decompiled with CFR 0.152.
 */
package org.appops.tsgen.jackson.module.grammar;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.appops.tsgen.jackson.module.grammar.base.AbstractNamedType;
import org.appops.tsgen.jackson.module.grammar.base.Value;
import org.appops.tsgen.jackson.module.writer.WriterPreferences;

public class StaticClassType
extends AbstractNamedType {
    private Map<String, Value> fields = new HashMap<String, Value>();

    public StaticClassType(String className) {
        super(className);
    }

    @Override
    public void writeDefInternal(Writer writer, WriterPreferences prefs) throws IOException {
        writer.write(String.format("class %s {\n", this.name));
        prefs.increaseIndentation();
        for (Map.Entry<String, Value> entry : this.fields.entrySet()) {
            writer.write(String.format("%sstatic %s: ", prefs.getIndentation(), entry.getKey()));
            entry.getValue().getType().write(writer);
            writer.write(" = ");
            writer.write(entry.getValue().getValue().toString());
            writer.write(";\n");
        }
        prefs.decreaseIndention();
        writer.write(prefs.getIndentation() + "}");
    }

    public Map<String, Value> getStaticFields() {
        return this.fields;
    }
}

