/*
 * Decompiled with CFR 0.152.
 */
package org.appops.tsgen.jackson.module.writer;

import java.io.IOException;
import java.io.Writer;
import org.appops.tsgen.jackson.module.grammar.EnumType;
import org.appops.tsgen.jackson.module.grammar.base.AbstractNamedType;
import org.appops.tsgen.jackson.module.writer.CustomAbstractTypeWriter;
import org.appops.tsgen.jackson.module.writer.WriterPreferences;

public class EnumTypeToEnumPatternWriter
implements CustomAbstractTypeWriter {
    @Override
    public boolean accepts(AbstractNamedType type, WriterPreferences preferences) {
        return type instanceof EnumType;
    }

    @Override
    public void writeDef(AbstractNamedType type, Writer writer, WriterPreferences preferences) throws IOException {
        EnumType enumType = (EnumType)type;
        String enumTypeName = enumType.getName();
        writer.write(String.format("class %s extends EnumPatternBase {\n", enumTypeName));
        preferences.increaseIndentation();
        for (String value : enumType.getValues()) {
            writer.write(String.format(preferences.getIndentation() + "static %s = new %s('%s');\n", value, enumTypeName, value));
        }
        writer.write(preferences.getIndentation() + "constructor(name:string){super(name)}\n");
        preferences.decreaseIndention();
        writer.write(preferences.getIndentation() + "}");
    }
}

