/*
 * Decompiled with CFR 0.152.
 */
package org.appops.tsgen.jackson.module.writer;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.appops.tsgen.jackson.module.grammar.base.AbstractNamedType;
import org.appops.tsgen.jackson.module.writer.CustomAbstractTypeWriter;
import org.appops.tsgen.jackson.module.writer.EnumTypeToEnumPatternWriter;

public class WriterPreferences {
    private String indentationStep = "    ";
    private int indentationLevel = 0;
    private List<CustomAbstractTypeWriter> customWriters = new ArrayList<CustomAbstractTypeWriter>();
    private boolean useEnumPattern;

    public void useEnumPattern() {
        this.addWriter(new EnumTypeToEnumPatternWriter());
        this.useEnumPattern = true;
    }

    public boolean isUseEnumPattern() {
        return this.useEnumPattern;
    }

    public void addWriter(CustomAbstractTypeWriter writer) {
        this.customWriters.add(writer);
    }

    public List<CustomAbstractTypeWriter> getCustomWriters() {
        return this.customWriters;
    }

    public boolean hasCustomWriter(AbstractNamedType type) {
        return this.getCustomWriter(type) != null;
    }

    public void writeDef(AbstractNamedType type, Writer writer) throws IOException {
        this.getCustomWriter(type).writeDef(type, writer, this);
    }

    public CustomAbstractTypeWriter getCustomWriter(AbstractNamedType type) {
        for (CustomAbstractTypeWriter writer : this.customWriters) {
            if (!writer.accepts(type, this)) continue;
            return writer;
        }
        return null;
    }

    public String getIndentation() {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i++ < this.indentationLevel) {
            sb.append(this.indentationStep);
        }
        return sb.toString();
    }

    public void setIndentationStep(String indentation) {
        this.indentationStep = indentation;
    }

    public void increaseIndentation() {
        ++this.indentationLevel;
    }

    public void decreaseIndention() {
        --this.indentationLevel;
    }
}

