/*
 * AppOps is a Java framework to develop, deploy microservices with ease and is available for free
 * and common use developed by AinoSoft ( www.ainosoft.com )
 *
 * AppOps and AinoSoft are registered trademarks of Aino Softwares private limited, India.
 *
 * Copyright (C) <2016> <Aino Softwares private limited>
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the
 * GNU General Public License as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version along with applicable additional terms as
 * provisioned by GPL 3.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License and applicable additional terms
 * along with this program.
 *
 * If not, see <https://www.gnu.org/licenses/> and <https://www.appops.org/license>
 */

package org.appops.core.service;

/**
 * Slim that represents version of an appops services as well as it's assets.
 *
 * @author deba
 * @version $Id: $Id
 */
public class Version {

  private int major;
  private int minor;
  private int patch;
  /**
   * Additional information for snapshot versions; null for non-snapshot (release) versions.
   */
  private String snapshotInfo;

  private static final Version DEFAULT_VERSION = new Version(0, 0, 1, "");

  /**
   * <p>defaultVersion.</p>
   *
   * @return a {@link org.appops.core.service.Version} object.
   */
  public static Version defaultVersion() {
    return DEFAULT_VERSION;
  }


  /**
   * <p>Constructor for Version.</p>
   */
  public Version() {

  }

  /**
   * Object constructor.
   *
   * @param major Major version number.
   * @param minor Minor version number.
   * @param patch Patch number.
   */
  public Version(int major, int minor, int patch) {
    setMajor(major);
    setMinor(minor);
    setPatch(patch);
  }

  /**
   * Object constructor.
   *
   * @param major Major version number.
   * @param minor Minor version number.
   * @param patch Patch number.
   * @param snapshotInfo Snapshot id or name.
   */
  public Version(int major, int minor, int patch, String snapshotInfo) {
    setMajor(major);
    setMinor(minor);
    setPatch(patch);
    setSnapshotInfo(snapshotInfo);
  }



  /**
   * <p>Getter for the field <code>major</code>.</p>
   *
   * @return a int.
   */
  public int getMajor() {
    return major;
  }

  /**
   * <p>Setter for the field <code>major</code>.</p>
   *
   * @param major a int.
   */
  public void setMajor(int major) {
    this.major = major;
  }

  /**
   * <p>Getter for the field <code>minor</code>.</p>
   *
   * @return a int.
   */
  public int getMinor() {
    return minor;
  }

  /**
   * <p>Setter for the field <code>minor</code>.</p>
   *
   * @param minor a int.
   */
  public void setMinor(int minor) {
    this.minor = minor;
  }

  /**
   * <p>Getter for the field <code>patch</code>.</p>
   *
   * @return a int.
   */
  public int getPatch() {
    return patch;
  }

  /**
   * <p>Setter for the field <code>patch</code>.</p>
   *
   * @param patch a int.
   */
  public void setPatch(int patch) {
    this.patch = patch;
  }

  /**
   * <p>Getter for the field <code>snapshotInfo</code>.</p>
   *
   * @return a {@link java.lang.String} object.
   */
  public String getSnapshotInfo() {
    return snapshotInfo;
  }

  /**
   * <p>Setter for the field <code>snapshotInfo</code>.</p>
   *
   * @param snapshotInfo a {@link java.lang.String} object.
   */
  public void setSnapshotInfo(String snapshotInfo) {
    this.snapshotInfo = snapshotInfo;
  }


  /**
   * <p>isSnapshot.</p>
   *
   * @return a boolean.
   */
  public boolean isSnapshot() {
    return ((snapshotInfo != null) && (snapshotInfo.length() > 0));
  }

  /** {@inheritDoc} */
  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append(major);
    sb.append(minor);
    sb.append(patch);
    if (isSnapshot()) {
      sb.append('-').append(snapshotInfo);
    }
    return sb.toString();
  }



}
