/*
 * Decompiled with CFR 0.152.
 */
package org.appops.configuration.generator;

import com.google.inject.Inject;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.appops.configuration.exception.ConfigurationException;
import org.appops.core.annotation.Config;
import org.appops.marshaller.DescriptorType;
import org.appops.marshaller.Marshaller;
import org.reflections.Reflections;
import org.reflections.scanners.FieldAnnotationsScanner;
import org.reflections.scanners.MethodParameterScanner;
import org.reflections.scanners.Scanner;

public class ConfigJsonGenerator {
    private Marshaller marshaller;

    public String generateConfiguration() {
        try {
            return this.generateConfiguration(null);
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
    }

    public String generateConfiguration(DescriptorType descriptorType) {
        if (descriptorType == null) {
            descriptorType = DescriptorType.JSON;
        }
        HashMap configMap = new HashMap();
        try {
            for (Class<?> clazz : this.classesTobeConfigured()) {
                configMap.put(clazz.getCanonicalName(), clazz.newInstance());
            }
            return this.getMarshaller().marshall(configMap, descriptorType);
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
    }

    public Set<Class<?>> findAnnotatedClasses(Class<? extends Annotation> annotation) {
        Reflections reflections = new Reflections("", new Scanner[]{new FieldAnnotationsScanner(), new MethodParameterScanner()});
        Set configClasses = reflections.getTypesAnnotatedWith(annotation);
        return configClasses;
    }

    public Set<Class<?>> classesTobeConfigured() {
        Reflections reflections = new Reflections("", new Scanner[]{new FieldAnnotationsScanner(), new MethodParameterScanner()});
        HashSet annotatedClasses = new HashSet();
        this.findFromConstructors(reflections, annotatedClasses);
        this.findFromMethods(reflections, annotatedClasses);
        return annotatedClasses;
    }

    private Set<Class<?>> findFromMethods(Reflections reflections, Set<Class<?>> annotatedClasses) {
        Set methods = reflections.getMethodsWithAnyParamAnnotated(Config.class);
        for (Method method : methods) {
            this.scanParameters(annotatedClasses, method.getParameters());
        }
        return annotatedClasses;
    }

    private Set<Class<?>> findFromConstructors(Reflections reflections, Set<Class<?>> annotatedClasses) {
        Set annoatatedConstructors = reflections.getConstructorsWithAnyParamAnnotated(Config.class);
        for (Constructor constructor : annoatatedConstructors) {
            this.scanParameters(annotatedClasses, constructor.getParameters());
        }
        return annotatedClasses;
    }

    private Set<Class<?>> scanParameters(Set<Class<?>> annotatedClasses, Parameter[] parameters) {
        for (Parameter parameter : parameters) {
            if (!parameter.isAnnotationPresent(Config.class)) continue;
            annotatedClasses.add(parameter.getType());
        }
        return annotatedClasses;
    }

    public Marshaller getMarshaller() {
        return this.marshaller;
    }

    @Inject
    public void setMarshaller(Marshaller marshaller) {
        this.marshaller = marshaller;
    }
}

