/*
 * Decompiled with CFR 0.152.
 */
package org.appops.core.deployment;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.File;
import org.appops.configuration.ContainerConfig;
import org.appops.configuration.ModuleConfig;
import org.appops.core.deployment.ConfigMap;
import org.appops.core.deployment.DeploymentMode;
import org.appops.core.deployment.JettyConfig;
import org.appops.core.deployment.WebConfig;
import org.appops.core.service.ExecutionMode;

public class ServiceConfiguration {
    private String serviceName;
    private File webappDirectory;
    private String gatewayUrl;
    private Class<?> annotationClass;
    private ExecutionMode executionMode;
    private WebConfig webConfig;
    @JsonIgnore
    private ModuleConfig modules;
    private ContainerConfig containerConfig;
    private JettyConfig jettyConfig;
    private ConfigMap serviceConfig;
    private DeploymentMode mode = DeploymentMode.CLUBBED;

    public ServiceConfiguration() {
        this.setWebConfig(new WebConfig());
        this.gatewayUrl = "http://localhost:8080/";
        this.setContainerConfig(new ContainerConfig(new File("Dockerfile")));
        this.setModules(new ModuleConfig());
        this.setWebappDirectory(new File("webapp"));
        this.setExecutionMode(ExecutionMode.SERVICE);
        this.setJettyConfig(new JettyConfig());
    }

    public WebConfig getWebConfig() {
        return this.webConfig;
    }

    public void setWebConfig(WebConfig webConfig) {
        this.webConfig = webConfig;
    }

    public ServiceConfiguration(String serviceName) {
        this();
    }

    public ServiceConfiguration(String name, String image) {
        this();
    }

    public Class<?> getAnnotationClass() {
        return this.annotationClass;
    }

    public void setAnnotationClass(Class<?> annotationClass) {
        this.annotationClass = annotationClass;
    }

    public ExecutionMode getExecutionMode() {
        return this.executionMode;
    }

    public void setExecutionMode(ExecutionMode executionMode) {
        this.executionMode = executionMode;
    }

    public ContainerConfig getContainerConfig() {
        return this.containerConfig;
    }

    public void setContainerConfig(ContainerConfig containerConfig) {
        this.containerConfig = containerConfig;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public File getWebappDirectory() {
        return this.webappDirectory;
    }

    public void setWebappDirectory(File webappDirectory) {
        this.webappDirectory = webappDirectory;
    }

    public String getGatewayUrl() {
        return this.gatewayUrl;
    }

    public void setGatewayUrl(String url) {
        this.gatewayUrl = url;
    }

    public JettyConfig getJettyConfig() {
        return this.jettyConfig;
    }

    public void setJettyConfig(JettyConfig jettyConfig) {
        this.jettyConfig = jettyConfig;
    }

    public ModuleConfig getModules() {
        return this.modules;
    }

    public void setModules(ModuleConfig modules) {
        this.modules = modules;
    }

    public ConfigMap getServiceConfig() {
        return this.serviceConfig;
    }

    public void setServiceConfig(ConfigMap serviceConfig) {
        this.serviceConfig = serviceConfig;
    }

    public void addConfig(String name, Object object) {
        if (this.getServiceConfig() == null) {
            this.serviceConfig = new ConfigMap();
        }
        this.serviceConfig.put(name, object);
    }

    public DeploymentMode getMode() {
        return this.mode;
    }

    public void setMode(DeploymentMode mode) {
        this.mode = mode;
    }

    public ServiceConfiguration lightweightCopy() {
        ServiceConfiguration serviceConfiguration = new ServiceConfiguration();
        serviceConfiguration.setWebConfig(this.getWebConfig());
        serviceConfiguration.setMode(this.getMode());
        serviceConfiguration.setServiceName(this.getServiceName());
        serviceConfiguration.setAnnotationClass(this.getAnnotationClass());
        serviceConfiguration.setJettyConfig(this.getJettyConfig());
        serviceConfiguration.setServiceConfig(this.getServiceConfig());
        return serviceConfiguration;
    }

    public String serviceUrl() {
        WebConfig webConfig = this.getWebConfig();
        return webConfig.getIp() + ":" + webConfig.getPort() + "/" + webConfig.getContextPath();
    }
}

