/*
 * Decompiled with CFR 0.152.
 */
package org.appops.marshaller;

import com.google.inject.Inject;
import org.appops.marshaller.DescriptorType;
import org.appops.marshaller.Marshaller;
import org.appops.marshaller.exception.MarshalException;
import org.appops.marshaller.exception.UnmarshalException;
import org.appops.marshaller.json.Jsonizer;
import org.appops.marshaller.xml.XmlMarshaller;
import org.appops.marshaller.yaml.YamlMarshaller;

public class MarshallerImpl
implements Marshaller {
    private Jsonizer jsonizer;
    private XmlMarshaller xmlMarshaller;
    private YamlMarshaller yamlMarshaller;

    @Override
    public String marshall(Object object, DescriptorType marshaller) {
        if (marshaller == null) {
            throw new MarshalException("Marshaller type is null.");
        }
        if (DescriptorType.JSON.equals(marshaller)) {
            return this.getJsonizer().toJson(object);
        }
        if (DescriptorType.XML.equals(marshaller)) {
            return this.getXmlMarshaller().toXml(object);
        }
        if (DescriptorType.YML.equals(marshaller)) {
            return this.getYamlMarshaller().toYaml(object);
        }
        throw new MarshalException("Marshaller type " + (String)marshaller.value() + " Not supported yet. Supported types - JSON, XML, YML");
    }

    @Override
    public <T> T unmarshall(String marshalledData, Class<T> clazz, DescriptorType unmarshaller) {
        if (unmarshaller == null) {
            throw new UnmarshalException("Marshaller type is null.");
        }
        if (DescriptorType.JSON.equals(unmarshaller)) {
            return this.getJsonizer().fromJson(marshalledData, clazz);
        }
        if (DescriptorType.XML.equals(unmarshaller)) {
            return this.getXmlMarshaller().fromXml(marshalledData, clazz);
        }
        if (DescriptorType.YML.equals(unmarshaller)) {
            return this.getYamlMarshaller().fromYaml(marshalledData, clazz);
        }
        throw new UnmarshalException("Marshaller type " + (String)unmarshaller.value() + " Not supported yet. Supported types - JSON, XML, YML");
    }

    public Jsonizer getJsonizer() {
        return this.jsonizer;
    }

    @Inject
    public void setJsonizer(Jsonizer jsonizer) {
        this.jsonizer = jsonizer;
    }

    public XmlMarshaller getXmlMarshaller() {
        return this.xmlMarshaller;
    }

    @Inject
    public void setXmlMarshaller(XmlMarshaller xmlMarshaller) {
        this.xmlMarshaller = xmlMarshaller;
    }

    public YamlMarshaller getYamlMarshaller() {
        return this.yamlMarshaller;
    }

    @Inject
    public void setYamlMarshaller(YamlMarshaller yamlMarshaller) {
        this.yamlMarshaller = yamlMarshaller;
    }
}

