/*
 * Decompiled with CFR 0.152.
 */
package org.appops.marshaller.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import org.appops.marshaller.exception.MarshalException;
import org.appops.marshaller.exception.UnmarshalException;
import org.appops.marshaller.json.Jsonizer;

public class JacksonJsonizer
implements Jsonizer {
    private ObjectMapper jsonMapper = this.createJsonMapper();

    @Override
    public String toJson(Object object) {
        try {
            return this.jsonMapper.writeValueAsString(object).trim();
        }
        catch (JsonProcessingException e) {
            throw new MarshalException(e);
        }
    }

    @Override
    public <T> T fromJson(String json, Class<T> clazz) {
        try {
            return (T)this.jsonMapper.readValue(json, clazz);
        }
        catch (JsonProcessingException e) {
            throw new UnmarshalException(e);
        }
    }

    private ObjectMapper createJsonMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
        mapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        mapper.enable(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        return mapper;
    }
}

