/**AppOps is a Java framework to develop,deploy microservices with ease and is available for/free*and common use developed by AinoSoft(www.ainosoft.com)**AppOps and AinoSoft are registered/trademarks of Aino Softwares private limited,India.**Copyright(C)<2016><Aino Softwares private/limited>**This program is free software:you can redistribute it and/or modify it under the terms/of the*GNU General Public License as published by the Free Software Foundation,either version 3/of/the*License,or(at your option)any later version along with applicable additional terms/as*provisioned by GPL 3.**This program is distributed in the hope that it will be useful,but/WITHOUT ANY WARRANTY;/without*even the implied warranty of MERCHANTABILITY or FITNESS FOR A/PARTICULAR PURPOSE.See the GNU*General Public License for more details.**You should have/received a copy of the GNU General Public License and applicable additional/terms*along with/this program.**If not,see<https:// www.gnu.org/licenses/>
// and
// <https://www.appops.org/license>
*/

package org.appops.core.deployment;

import java.io.File;import org.appops.core.exception.CoreException;
import org.appops.core.service.ServiceConfig;

/***Represents appops deployment.**

@author deba
 * @version $Id: $Id
 */
 @Deprecated
 public class DeploymentConfig {

 private File configDir;
 private String currentProfile;
 private String entryPoint;
 private DeploymentMode mode = DeploymentMode.CLUBBED;
 private String url;
 private ServiceConfigMap services;

 /**
 * Default constructor.
 */
 public DeploymentConfig() {
 services = new ServiceConfigMap();
 currentProfile = "default";
 url = "http://localhost:8080/";
 configDir = new File("app/env-config/");
 }

 /**
 * <p>
 * addService.
 * </p>
 *
 * @param name a {@link java.lang.String} object.
 * @param image a {@link java.lang.String} object.
 */
 public void addService(String name, String image) {
 addService(new ServiceConfig(name, image));
 }

 /**
 * <p>
 * addService.
 * </p>
 *
 * @param config a {@link org.appops.core.service.ServiceConfig} object.
 */
 public void addService(ServiceConfig config) {
 getServices().put(config.getServiceName(), config);
 }

 /**
 * <p>
 * Getter for the field <code>mode</code>.
 * </p>
 *
 * @return a {@link org.appops.core.deployment.DeploymentMode} object.
 */
 public DeploymentMode getMode() {
 return mode;
 }

 /**
 * <p>
 * Setter for the field <code>mode</code>.
 * </p>
 *
 * @param mode a {@link org.appops.core.deployment.DeploymentMode} object.
 */
 public void setMode(DeploymentMode mode) {
 this.mode = mode;
 }

 /**
 * <p>
 * Getter for the field <code>url</code>.
 * </p>
 *
 * @return a {@link java.lang.String} object.
 */
 public String getUrl() {
 return url;
 }

 /**
 * <p>
 * Setter for the field <code>url</code>.
 * </p>
 *
 * @param url a {@link java.lang.String} object.
 */
 public void setUrl(String url) {
 this.url = url;
 }

 /**
 * <p>
 * Getter for the field <code>configDir</code>.
 * </p>
 *
 * @return a {@link java.io.File} object.
 */
 public File getConfigDir() {
 return configDir;
 }

 /**
 * <p>
 * Setter for the field <code>configDir</code>.
 * </p>
 *
 * @param configDir a {@link java.io.File} object.
 */
 public void setConfigDir(File configDir) {
 this.configDir = configDir;
 }

 /**
 * <p>
 * Getter for the field <code>currentProfile</code>.
 * </p>
 *
 * @return a {@link java.lang.String} object.
 */
 public String getCurrentProfile() {
 return currentProfile;
 }

 /**
 * <p>
 * Setter for the field <code>currentProfile</code>.
 * </p>
 *
 * @param currentProfile a {@link java.lang.String} object.
 */
 public void setCurrentProfile(String currentProfile) {
 this.currentProfile = currentProfile;
 }

 /**
 * <p>
 * Getter for the field <code>services</code>.
 * </p>
 *
 * @return a {@link org.appops.core.deployment.ServiceConfigMap} object.
 */
 public ServiceConfigMap getServices() {
 return services;
 }

 /**
 * <p>
 * Setter for the field <code>services</code>.
 * </p>
 *
 * @param services a {@link org.appops.core.deployment.ServiceConfigMap} object.
 */
 public void setServices(ServiceConfigMap services) {
 this.services = services;
 }

 /**
 * <p>
 * Getter for the field <code>entryPoint</code>.
 * </p>
 *
 * @return a {@link java.lang.String} object.
 */
 public String getEntryPoint() {
 return entryPoint;
 }

 /**
 * <p>
 * Setter for the field <code>entryPoint</code>.
 * </p>
 *
 * @param entryPoint a {@link java.lang.String} object.
 */
 public void setEntryPoint(String entryPoint) {
 this.entryPoint = entryPoint;
 }

 /**
 * Creates lightweight copy of deployment configuration.
 *
 * @return Lightweight deployment configuration.
 */
 public DeploymentConfig lightweightCopy() {
 DeploymentConfig deploymentConfig = new DeploymentConfig();
 deploymentConfig.setMode(getMode());
 deploymentConfig.setUrl(getUrl());
 return deploymentConfig;
 }

 /**
 * Provides entry point service configuration.
 *
 * @return Entry point service configuration.
 */
 public ServiceConfig entryPointServiceConfig() {
 if (entryPoint != null && !entryPoint.isEmpty()) {
 return getServices().get(entryPoint);
 } else if (getServices().size() == 1) {
 return getServices().values().iterator().next();
 } else {
 throw new CoreException("Entry point service not provided in deployment configuration.");
 }
 }



 }
