/*
 * AppOps is a Java framework to develop, deploy microservices with ease and is available for free
 * and common use developed by AinoSoft ( www.ainosoft.com )
 *
 * AppOps and AinoSoft are registered trademarks of Aino Softwares private limited, India.
 *
 * Copyright (C) <2016> <Aino Softwares private limited>
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the
 * GNU General Public License as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version along with applicable additional terms as
 * provisioned by GPL 3.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License and applicable additional terms
 * along with this program.
 *
 * If not, see <https://www.gnu.org/licenses/> and <https://www.appops.org/license>
 */

package org.appops.core.service.meta;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.appops.core.annotation.Opinion;
import org.appops.core.service.ExecutionMode;
import org.appops.core.service.ServiceRoute;
import org.appops.core.service.Stage;
import org.appops.core.service.Version;

/**
 * Stores definition of appops service.
 *
 * @author deba
 * @version $Id: $Id
 */

@Opinion(name = "service")
public class ServiceMeta {

  private String name;
  private Long id;
  private Set<InterfaceMeta> interfaces = new HashSet<>();
  private boolean isDynamic;
  private ServiceRoute route;
  private String dockerFile;
  private Integer deploymentOrder = 0;
  private Version version = Version.defaultVersion();
  private Stage stage = Stage.DEVELOPMENT;
  private ExecutionMode executionMode = ExecutionMode.SERVICE;

  /**
   * <p>Constructor for ServiceMeta.</p>
   */
  public ServiceMeta() {

  }

  /**
   * <p>Constructor for ServiceMeta.</p>
   *
   * @param name a {@link java.lang.String} object.
   */
  public ServiceMeta(String name) {
    setName(name);
  }

  /**
   * <p>addInterface.</p>
   *
   * @param intrfc a {@link org.appops.core.service.meta.InterfaceMeta} object.
   */
  public void addInterface(InterfaceMeta intrfc) {
    this.interfaces.add(intrfc);
  }

  /**
   * <p>Getter for the field <code>name</code>.</p>
   *
   * @return a {@link java.lang.String} object.
   */
  public String getName() {
    return name;
  }

  /**
   * <p>Setter for the field <code>name</code>.</p>
   *
   * @param name a {@link java.lang.String} object.
   */
  public void setName(String name) {
    this.name = name;
  }

  /**
   * <p>Getter for the field <code>id</code>.</p>
   *
   * @return a {@link java.lang.Long} object.
   */
  public Long getId() {
    return id;
  }

  /**
   * <p>Setter for the field <code>id</code>.</p>
   *
   * @param id a {@link java.lang.Long} object.
   */
  public void setId(Long id) {
    this.id = id;
  }

  /**
   * <p>isDynamic.</p>
   *
   * @return a boolean.
   */
  public boolean isDynamic() {
    return isDynamic;
  }

  /**
   * <p>setDynamic.</p>
   *
   * @param isDynamic a boolean.
   */
  public void setDynamic(boolean isDynamic) {
    this.isDynamic = isDynamic;
  }

  /**
   * <p>Getter for the field <code>interfaces</code>.</p>
   *
   * @return a {@link java.util.Set} object.
   */
  public Set<InterfaceMeta> getInterfaces() {
    return interfaces;
  }

  /**
   * Creates a lightweight copy to avoid cyclic object dependency.
   *
   * @return Lightweight copy of service meta.
   */
  public ServiceMeta lightweightCopy() {
    ServiceMeta serviceMeta = new ServiceMeta(getName());
    serviceMeta.setId(getId());
    serviceMeta.setDynamic(isDynamic());
    serviceMeta.setRoute(getRoute());
    serviceMeta.setDockerFile(getDockerFile());
    return serviceMeta;
  }

  /**
   * Provides service context path.
   *
   * @return Context path of service, returns name of the service if path is null.
   */
  public String contextPath() {
    if (getRoute() == null || getRoute().getSourceContext() == null) {
      return getName();
    }
    return getRoute().getSourceContext();
  }

  /**
   * <p>Getter for the field <code>route</code>.</p>
   *
   * @return a {@link org.appops.core.service.ServiceRoute} object.
   */
  public ServiceRoute getRoute() {
    return route;
  }

  /**
   * <p>Setter for the field <code>route</code>.</p>
   *
   * @param route a {@link org.appops.core.service.ServiceRoute} object.
   */
  public void setRoute(ServiceRoute route) {
    this.route = route;
  }

  /**
   * <p>Getter for the field <code>dockerFile</code>.</p>
   *
   * @return a {@link java.lang.String} object.
   */
  public String getDockerFile() {
    return dockerFile;
  }

  /**
   * <p>Setter for the field <code>dockerFile</code>.</p>
   *
   * @param dockerFile a {@link java.lang.String} object.
   */
  public void setDockerFile(String dockerFile) {
    this.dockerFile = dockerFile;
  }

  /**
   * <p>Getter for the field <code>deploymentOrder</code>.</p>
   *
   * @return a {@link java.lang.Integer} object.
   */
  public Integer getDeploymentOrder() {
    return deploymentOrder;
  }

  /**
   * <p>Setter for the field <code>deploymentOrder</code>.</p>
   *
   * @param deploymentOrder a int.
   */
  public void setDeploymentOrder(int deploymentOrder) {
    this.deploymentOrder = deploymentOrder;
  }

  /**
   * <p>Getter for the field <code>version</code>.</p>
   *
   * @return a {@link org.appops.core.service.Version} object.
   */
  public Version getVersion() {
    return version;
  }

  /**
   * <p>Setter for the field <code>version</code>.</p>
   *
   * @param version a {@link org.appops.core.service.Version} object.
   */
  public void setVersion(Version version) {
    this.version = version;
  }

  /**
   * <p>Getter for the field <code>stage</code>.</p>
   *
   * @return a {@link org.appops.core.service.Stage} object.
   */
  public Stage getStage() {
    return stage;
  }

  /**
   * <p>Setter for the field <code>stage</code>.</p>
   *
   * @param stage a {@link org.appops.core.service.Stage} object.
   */
  public void setStage(Stage stage) {
    this.stage = stage;
  }

  /**
   * <p>Getter for the field <code>executionMode</code>.</p>
   *
   * @return a {@link org.appops.core.service.ExecutionMode} object.
   */
  public ExecutionMode getExecutionMode() {
    return executionMode;
  }

  /**
   * <p>Setter for the field <code>executionMode</code>.</p>
   *
   * @param executionMode a {@link org.appops.core.service.ExecutionMode} object.
   */
  public void setExecutionMode(ExecutionMode executionMode) {
    this.executionMode = executionMode;
  }

  /**
   * <p>addInterfaces.</p>
   *
   * @param interfaces a {@link java.util.Collection} object.
   */
  public void addInterfaces(Collection<InterfaceMeta> interfaces) {
    getInterfaces().addAll(interfaces);
  }

}
