/*
 * Decompiled with CFR 0.152.
 */
package org.appops.core;

import com.google.inject.Inject;
import com.google.inject.Module;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.appops.core.TypeScanner;
import org.appops.core.annotation.ImplModule;
import org.appops.core.annotation.SlimModule;
import org.reflections.Reflections;
import org.reflections.scanners.AbstractScanner;
import org.reflections.scanners.FieldAnnotationsScanner;
import org.reflections.scanners.MethodAnnotationsScanner;
import org.reflections.scanners.MethodParameterNamesScanner;
import org.reflections.scanners.MethodParameterScanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.reflections.scanners.TypeElementsScanner;
import org.reflections.util.FilterBuilder;

public class ClassPathAnalyser {
    private TypeScanner typeScanner;
    private Reflections reflections;
    private final List<String> defaultPackages = Arrays.asList("org.appops", "com.ainosoft");

    public ClassPathAnalyser() {
        this(null, new String[0]);
    }

    public ClassPathAnalyser(ClassLoader loader, String ... packages) {
        HashSet<AbstractScanner> scanners = new HashSet<AbstractScanner>(Arrays.asList(new TypeAnnotationsScanner(), new FieldAnnotationsScanner(), new MethodParameterScanner(), new MethodParameterNamesScanner(), new TypeElementsScanner(), new SubTypesScanner(), new MethodAnnotationsScanner()));
        if (loader != null) {
            scanners.add((AbstractScanner)loader);
        }
        this.reflections = this.createReflections(scanners, Arrays.asList(packages));
    }

    private Reflections createReflections(Set<Object> scanners, List<String> packages) {
        packages = packages == null || packages.size() <= 0 ? this.defaultPackages : packages;
        FilterBuilder filters = new FilterBuilder();
        for (String packagePrefix : packages) {
            filters.include(FilterBuilder.prefix((String)packagePrefix));
        }
        return new Reflections(new Object[]{scanners, filters});
    }

    public Set<Class<?>> getAnnotatedTypes(Class<? extends Annotation> annotation) {
        return this.reflections.getTypesAnnotatedWith(annotation);
    }

    public Map<String, Set<Class<? extends Module>>> getSlimModuleAnnotatedTypeMap() {
        Set<Class<?>> configClasses = this.getAnnotatedTypes(SlimModule.class);
        HashMap<String, Set<Class<? extends Module>>> map = new HashMap<String, Set<Class<? extends Module>>>();
        for (Class<?> annotatedClass : configClasses) {
            if (annotatedClass.getAnnotation(SlimModule.class) == null) continue;
            String ServiceName = annotatedClass.getAnnotation(SlimModule.class).serviceName().getCanonicalName();
            if (map.get(ServiceName) == null) {
                HashSet list = new HashSet();
                list.add(annotatedClass);
                map.put(ServiceName, list);
                continue;
            }
            ((Set)map.get(ServiceName)).add(annotatedClass);
        }
        return map;
    }

    public Map<String, Set<Class<? extends Module>>> getImplModuleAnnotatedTypeMap() {
        Set<Class<?>> configClasses = this.getAnnotatedTypes(ImplModule.class);
        HashMap<String, Set<Class<? extends Module>>> map = new HashMap<String, Set<Class<? extends Module>>>();
        for (Class<?> annotatedClass : configClasses) {
            if (annotatedClass.getAnnotation(ImplModule.class) == null) continue;
            String ServiceName = annotatedClass.getAnnotation(ImplModule.class).serviceName().getCanonicalName();
            if (map.get(ServiceName) == null) {
                HashSet list = new HashSet();
                list.add(annotatedClass);
                map.put(ServiceName, list);
                continue;
            }
            ((Set)map.get(ServiceName)).add(annotatedClass);
        }
        return map;
    }

    public List<Method> getAnnotatedMethods(Class<?> clazz, Class<? extends Annotation> methodAnnotation) {
        return this.getTypeScanner().getAnnotatedMethods(clazz, methodAnnotation);
    }

    public TypeScanner getTypeScanner() {
        return this.typeScanner;
    }

    @Inject
    public void setTypeScanner(TypeScanner typeScanner) {
        this.typeScanner = typeScanner;
    }

    public <T> Collection<Class<? extends T>> subTypesOf(Class<T> superType) {
        return this.reflections.getSubTypesOf(superType);
    }
}

