/*
 * AppOps is a Java framework to develop, deploy microservices with ease and is available for free
 * and common use developed by AinoSoft ( www.ainosoft.com )
 *
 * AppOps and AinoSoft are registered trademarks of Aino Softwares private limited, India.
 *
 * Copyright (C) <2016> <Aino Softwares private limited>
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the
 * GNU General Public License as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version along with applicable additional terms as
 * provisioned by GPL 3.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License and applicable additional terms
 * along with this program.
 *
 * If not, see <https://www.gnu.org/licenses/> and <https://www.appops.org/license>
 */

package org.appops.marshaller.yaml;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import org.appops.marshaller.exception.MarshalException;
import org.appops.marshaller.exception.UnmarshalException;

/**
 * <p>JacksonYamlMarshaller class.</p>
 *
 * @author deba
 * @version $Id: $Id
 */
public class JacksonYamlMarshaller implements YamlMarshaller {

  private YAMLMapper mapper;

  /**
   * <p>Constructor for JacksonYamlMarshaller.</p>
   */
  public JacksonYamlMarshaller() {
    mapper = createYamlMapper();
  }

  /** {@inheritDoc} */
  @Override
  public String toYaml(Object instance) {
    try {
      return mapper.writeValueAsString(instance).trim();
    } catch (JsonProcessingException e) {
      throw new MarshalException(e);
    }
  }

  /** {@inheritDoc} */
  @Override
  public <T> T fromYaml(String yaml, Class<T> clazz) {
    try {
      return mapper.readValue(yaml, clazz);
    } catch (JsonProcessingException e) {
      throw new UnmarshalException(e);
    }
  }

  /**
   * Creates and configures XmlMapper.
   *
   * @return XmlMapper instance.
   */
  private YAMLMapper createYamlMapper() {
    YAMLMapper mapperToReturn = new YAMLMapper();
    mapperToReturn.enable(SerializationFeature.INDENT_OUTPUT);
    mapperToReturn.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
    mapperToReturn.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
    mapperToReturn.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    mapperToReturn.enable(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT);
    // mapperToReturn.setSerializationInclusion(Include.NON_EMPTY);
    // mapperToReturn.activateDefaultTypingAsProperty(new AppopsPolymorphicTypeValidator(),
    // DefaultTyping.OBJECT_AND_NON_CONCRETE, "$T");


    return mapperToReturn;
  }

}
