/*
 * Decompiled with CFR 0.152.
 */
package org.appops.marshaller;

import org.apache.commons.io.FilenameUtils;
import org.appops.core.constant.IterableConstant;
import org.appops.core.exception.CoreException;

public class DescriptorType
extends IterableConstant<String> {
    public static final DescriptorType JSON = new DescriptorType("json");
    public static final DescriptorType XML = new DescriptorType("xml");
    public static final DescriptorType YML = new DescriptorType("yml");

    protected DescriptorType(String value) {
        super(value);
    }

    public static DescriptorType fromExtension(String filename) {
        String extension = FilenameUtils.getExtension((String)filename);
        if (((String)JSON.value()).equalsIgnoreCase(extension)) {
            return JSON;
        }
        if (((String)XML.value()).equalsIgnoreCase(extension)) {
            return XML;
        }
        if (((String)YML.value()).equalsIgnoreCase(extension)) {
            return YML;
        }
        throw new CoreException("No marshaller type is supported for file type -> " + extension);
    }
}

