/*
 * Decompiled with CFR 0.152.
 */
package org.appops.configuration;

import com.google.inject.Module;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.appops.core.deployment.DeploymentMode;
import org.appops.core.exception.CoreException;

public class ModuleConfig {
    private Set<Class<? extends Module>> slimModules = new HashSet<Class<? extends Module>>();
    private Set<Class<? extends Module>> implModules = new HashSet<Class<? extends Module>>();

    public ModuleConfig() {
    }

    public ModuleConfig(ModuleConfig moduleConfig) {
        this();
        this.merge(moduleConfig);
    }

    public Set<Class<? extends Module>> getSlimModules() {
        return this.slimModules;
    }

    public ModuleConfig merge(ModuleConfig config) {
        if (config.getSlimModules() != null) {
            this.slimModules.addAll(config.getSlimModules());
        }
        this.implModules.addAll(config.getImplModules());
        return this;
    }

    public void setSlimModules(Set<Class<? extends Module>> slimModules) {
        this.slimModules = slimModules;
    }

    public Set<Class<? extends Module>> getImplModules() {
        return this.implModules;
    }

    public void setImplModules(Set<Class<? extends Module>> implModules) {
        this.implModules = implModules;
    }

    public List<Module> enabledModules(DeploymentMode mode, ClassLoader classLoader) {
        ArrayList<Module> modulesToReturn;
        block4: {
            Logger logger = Logger.getLogger(this.getClass().getCanonicalName());
            modulesToReturn = new ArrayList<Module>();
            try {
                if (DeploymentMode.CLUBBED.equals((Object)mode)) {
                    modulesToReturn.addAll(this.instantiateModules(this.getImplModules(), classLoader));
                    break block4;
                }
                if (DeploymentMode.STANDALONE.equals((Object)mode)) {
                    modulesToReturn.addAll(this.instantiateModules(this.getSlimModules(), classLoader));
                    break block4;
                }
                throw new CoreException("Invalid Deployment Mode :" + mode.name());
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Exception in :: getModules() " + e);
            }
        }
        return modulesToReturn;
    }

    public List<Module> enabledModules(DeploymentMode mode) {
        return this.enabledModules(mode, null);
    }

    public List<Module> instantiateModules(Set<Class<? extends Module>> moduleClassNames, ClassLoader classLoader) {
        try {
            ArrayList<Module> modulesToReturn = new ArrayList<Module>();
            for (Class<? extends Module> moduleClazz : moduleClassNames) {
                modulesToReturn.add(moduleClazz.newInstance());
            }
            return modulesToReturn;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new CoreException(e);
        }
    }
}

