/*
 * AppOps is a Java framework to develop, deploy microservices with ease and is available for free
 * and common use developed by AinoSoft ( www.ainosoft.com )
 *
 * AppOps and AinoSoft are registered trademarks of Aino Softwares private limited, India.
 *
 * Copyright (C) <2016> <Aino Softwares private limited>
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the
 * GNU General Public License as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version along with applicable additional terms as
 * provisioned by GPL 3.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License and applicable additional terms
 * along with this program.
 *
 * If not, see <https://www.gnu.org/licenses/> and <https://www.appops.org/license>
 */

package org.appops.configuration.generator;

import javax.validation.constraints.NotNull;
import org.appops.marshaller.DescriptorType;

/**
 * <p>
 * ConfigWrapper class.
 * </p>
 *
 * @author deba
 * @version $Id: $Id
 */
public class ConfigWrapper {

  private DescriptorType descriptorType = DescriptorType.YML;
  private String config;

  /**
   * <p>
   * Constructor for ConfigWrapper.
   * </p>
   */
  public ConfigWrapper() {

  }

  /**
   * <p>
   * Constructor for ConfigWrapper.
   * </p>
   *
   * @param config a {@link java.lang.String} object.
   */
  public ConfigWrapper(String config) {
    this(config, DescriptorType.YML);
  }

  /**
   * Object constructor.
   *
   * @param config Configuration string.
   * @param descType Descriptor type e.g. JSON,XML etc.
   */
  public ConfigWrapper(@NotNull String config, @NotNull DescriptorType descType) {

    setConfig(config);
    setDescriptorType(descType);
  }

  /**
   * <p>
   * Getter for the field <code>descriptorType</code>.
   * </p>
   *
   * @return a {@link org.appops.marshaller.DescriptorType} object.
   */
  public DescriptorType getDescriptorType() {
    return descriptorType;
  }

  /**
   * <p>
   * Setter for the field <code>descriptorType</code>.
   * </p>
   *
   * @param descriptorType a {@link org.appops.marshaller.DescriptorType} object.
   */
  public void setDescriptorType(DescriptorType descriptorType) {
    this.descriptorType = descriptorType;
  }

  /**
   * <p>
   * Getter for the field <code>config</code>.
   * </p>
   *
   * @return a {@link java.lang.String} object.
   */
  public String getConfig() {
    return config;
  }

  /**
   * <p>
   * Setter for the field <code>config</code>.
   * </p>
   *
   * @param config a {@link java.lang.String} object.
   */
  public void setConfig(String config) {
    this.config = config;
  }

}
