/*
 * AppOps is a Java framework to develop, deploy microservices with ease and is available for free
 * and common use developed by AinoSoft ( www.ainosoft.com )
 *
 * AppOps and AinoSoft are registered trademarks of Aino Softwares private limited, India.
 *
 * Copyright (C) <2016> <Aino Softwares private limited>
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the
 * GNU General Public License as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version along with applicable additional terms as
 * provisioned by GPL 3.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License and applicable additional terms
 * along with this program.
 *
 * If not, see <https://www.gnu.org/licenses/> and <https://www.appops.org/license>
 */

package org.appops.configuration.guice;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import org.appops.configuration.store.ConfigurationStore;
import org.appops.configuration.store.CurrentRunningServiceContext;
import org.appops.core.CoreModule;
import org.appops.core.annotation.Config;
import com.google.inject.Singleton;
import com.google.inject.matcher.AbstractMatcher;
import com.google.inject.matcher.Matchers;

/**
 * Configuration service guice module.
 *
 * @author deba
 * @version $Id: $Id
 */
public class ConfigServiceModule extends CoreModule {


  /** {@inheritDoc} */
  @Override
  public void configure() {
    bind(ConfigurationStore.class).in(Singleton.class);
    bind(CurrentRunningServiceContext.class).in(Singleton.class);
    ConfigProvisionInterceptor customProvisionListener = new ConfigProvisionInterceptor();
    requestInjection(customProvisionListener);
    bindInterceptor(Matchers.any(), new ConfigMethodMatcher(), customProvisionListener);

  }

  /**
   * Custom guice matcher for matching methods which needs configuration injection.
   */
  private final class ConfigMethodMatcher extends AbstractMatcher<Method> {
    @Override
    public boolean matches(final Method method) {
      boolean configInjection = false;
      for (Parameter parameter : method.getParameters()) {
        if (parameter.isAnnotationPresent(Config.class)) {
          configInjection = true;
          break;
        }
      }
      return configInjection && !method.isSynthetic();
    }
  }
  // /**
  // * Custom guice matcher for matching methods which needs configuration injection.
  // */
  // private final class ServiceOperationMatcher extends AbstractMatcher<Method> {
  // @Override
  // public boolean matches(final Method method) {
  // boolean configInjection = false;
  //
  // if (method.isAnnotationPresent(ServiceOp.class)) {
  // configInjection = true;
  //
  //
  // }
  // return configInjection && !method.isSynthetic();
  // }
  // }
}
