package org.appops.configuration.store;

import java.lang.annotation.Annotation;

import org.appops.core.deployment.DeploymentMode;
import org.appops.core.deployment.ServiceConfiguration;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;

/**
 * This class holds the current running Service context to perform further
 * actions using this context .
 *
 */
public class CurrentRunningServiceContext {

	private String currentRunningServiceName;
	private ServiceConfiguration serviceConfiguration;

	private java.lang.Class<? extends Annotation> serviceAnnotation;

	/**
	 * sets the current running service context .
	 * 
	 * @param serviceName       name of service .
	 * @param config            service configuration for service .
	 * @param serviceAnnotation annotation class of service .
	 */
	public void currentRunningService(String serviceName, ServiceConfiguration config,
			java.lang.Class<? extends Annotation> serviceAnnotation) {
		if (config != null && !config.getMode().toString().equalsIgnoreCase(DeploymentMode.STANDALONE.toString())) {
			setCurrentRunningService(serviceName);
			setServiceConfiguration(config);
			setServiceAnnotation(serviceAnnotation);
		}

	}

	public String getCurrentRunningService() {

		return currentRunningServiceName;
	}

	public void setCurrentRunningService(String currentRunningService) {
		this.currentRunningServiceName = currentRunningService;
	}

	public ServiceConfiguration getServiceConfiguration() {

		return serviceConfiguration;
	}

	public void setServiceConfiguration(ServiceConfiguration serviceConfiguration) {
		this.serviceConfiguration = serviceConfiguration;
	}

	public java.lang.Class<? extends Annotation> getServiceAnnotation() {
		return serviceAnnotation;
	}

	public void setServiceAnnotation(java.lang.Class<? extends Annotation> serviceAnnotation) {
		this.serviceAnnotation = serviceAnnotation;
	}
}
