/*
 * Decompiled with CFR 0.152.
 */
package org.appops.configuration.store;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.Map;
import org.appops.configuration.generator.ConfigWrapper;
import org.appops.marshaller.DescriptorType;

public class ConfigurationStore {
    private static final String ENHANCER_BY_GUICE = "$$EnhancerByGuice";
    private static final String DEFAULT = "default";
    private Table<String, String, ConfigWrapper> configTable = HashBasedTable.create();

    public void addConfiguration(String className, String configuration) {
        if (className.contains(ENHANCER_BY_GUICE)) {
            className = className.substring(0, className.indexOf(ENHANCER_BY_GUICE));
        }
        this.configTable.put((Object)DEFAULT, (Object)className, (Object)new ConfigWrapper(configuration));
    }

    public void addConfiguration(String className, String configuration, DescriptorType descriptorType) {
        if (className.contains(ENHANCER_BY_GUICE)) {
            className = className.substring(0, className.indexOf(ENHANCER_BY_GUICE));
        }
        this.configTable.put((Object)DEFAULT, (Object)className, (Object)new ConfigWrapper(configuration, descriptorType));
    }

    public void addConfiguration(String serviceName, String className, String configuration) {
        if (className.contains(ENHANCER_BY_GUICE)) {
            className = className.substring(0, className.indexOf(ENHANCER_BY_GUICE));
        }
        if (serviceName == null) {
            serviceName = DEFAULT;
        }
        this.configTable.put((Object)serviceName, (Object)className, (Object)new ConfigWrapper(configuration));
    }

    public String getConfiguration(String className) {
        if (className.contains(ENHANCER_BY_GUICE)) {
            className = className.substring(0, className.indexOf(ENHANCER_BY_GUICE));
        }
        Map classConfigMap = this.configTable.column((Object)className);
        for (Map.Entry entry : classConfigMap.entrySet()) {
            if (entry.getValue() == null) continue;
            return ((ConfigWrapper)entry.getValue()).getConfig();
        }
        return null;
    }

    public String getConfiguration(String serviceName, String className) {
        if (this.configTable.row((Object)serviceName) != null && this.configTable.row((Object)serviceName).get(className) != null) {
            return ((ConfigWrapper)this.configTable.row((Object)serviceName).get(className)).getConfig();
        }
        return null;
    }

    public ConfigWrapper getConfigWrapper(String className) {
        if (className.contains(ENHANCER_BY_GUICE)) {
            className = className.substring(0, className.indexOf(ENHANCER_BY_GUICE));
        }
        Map classConfigMap = this.configTable.column((Object)className);
        for (Map.Entry entry : classConfigMap.entrySet()) {
            if (entry.getValue() == null) continue;
            return (ConfigWrapper)entry.getValue();
        }
        return null;
    }

    public Map<String, ConfigWrapper> getConfigWrapperCollection(String className) {
        if (className.contains(ENHANCER_BY_GUICE)) {
            className = className.substring(0, className.indexOf(ENHANCER_BY_GUICE));
        }
        Map classConfigMap = this.configTable.column((Object)className);
        return classConfigMap;
    }

    public Map<String, ConfigWrapper> getAllServiceConfig(String serviceName) {
        return this.configTable.row((Object)serviceName);
    }

    public boolean isConfigurationPresent(String className) {
        return this.configTable.containsColumn((Object)className);
    }

    public ConfigWrapper getConfigWrapperByService(String className, String serviceName) {
        if (className.contains(ENHANCER_BY_GUICE)) {
            className = className.substring(0, className.indexOf(ENHANCER_BY_GUICE));
        }
        Map classConfigMap = this.configTable.column((Object)className);
        for (Map.Entry entry : classConfigMap.entrySet()) {
            if (entry.getValue() == null || !((String)entry.getKey()).equals(serviceName)) continue;
            return (ConfigWrapper)entry.getValue();
        }
        return null;
    }
}

