/*
 * Decompiled with CFR 0.152.
 */
package org.appops.marshaller.xml;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.xml.JacksonXmlModule;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import org.appops.marshaller.exception.MarshalException;
import org.appops.marshaller.exception.UnmarshalException;
import org.appops.marshaller.xml.XmlMarshaller;

public class JacksonXmlMarshaller
implements XmlMarshaller {
    private XmlMapper xmlMapper = this.createXmlMapper();

    @Override
    public String toXml(Object object) {
        try {
            return this.xmlMapper.writeValueAsString(object).trim();
        }
        catch (JsonProcessingException e) {
            throw new MarshalException(e);
        }
    }

    @Override
    public <T> T fromXml(String xml, Class<T> clazz) {
        try {
            return (T)this.xmlMapper.readValue(xml, clazz);
        }
        catch (JsonProcessingException e) {
            throw new UnmarshalException(e);
        }
    }

    private XmlMapper createXmlMapper() {
        JacksonXmlModule xmlModule = new JacksonXmlModule();
        xmlModule.setDefaultUseWrapper(false);
        XmlMapper mapperToReturn = new XmlMapper(xmlModule);
        mapperToReturn.enable(SerializationFeature.INDENT_OUTPUT);
        mapperToReturn.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        mapperToReturn.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        mapperToReturn.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        mapperToReturn.enable(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT);
        mapperToReturn.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        return mapperToReturn;
    }
}

