/*
 * Decompiled with CFR 0.152.
 */
package org.appops.configuration.guice;

import com.google.inject.Inject;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Map;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.appops.configuration.generator.ConfigWrapper;
import org.appops.configuration.provider.ConfigurationProvider;
import org.appops.configuration.provider.RunningServiceContextProvider;
import org.appops.core.annotation.Config;
import org.appops.marshaller.Marshaller;

public class ConfigProvisionInterceptor
implements MethodInterceptor {
    private ConfigurationProvider configurationProvider;
    private Marshaller marshaller;
    private RunningServiceContextProvider runningServiceContextProvider;

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Method m = invocation.getMethod();
        Parameter[] parameters = m.getParameters();
        Object[] args = invocation.getArguments();
        Map<String, ConfigWrapper> config = null;
        for (int i = 0; i < parameters.length; ++i) {
            Parameter parameter = parameters[i];
            if (!parameter.isAnnotationPresent(Config.class)) continue;
            config = this.configurationProvider.getConfigWrapperCollection(parameter.getType().getCanonicalName());
            for (Map.Entry<String, ConfigWrapper> entry : config.entrySet()) {
                ConfigWrapper configWrapper = entry.getValue();
                if (configWrapper == null || configWrapper.getConfig() == null || configWrapper.getConfig().isEmpty()) continue;
                Object paramValue = this.getMarshaller().unmarshall(configWrapper.getConfig(), parameter.getType(), configWrapper.getDescriptorType());
                args[i] = paramValue;
            }
        }
        return invocation.proceed();
    }

    @Inject
    public void setCustomProvisionListener(ConfigurationProvider configurationProvider) {
        this.configurationProvider = configurationProvider;
    }

    public Marshaller getMarshaller() {
        return this.marshaller;
    }

    @Inject
    public void setMarshaller(Marshaller marshaller) {
        this.marshaller = marshaller;
    }

    public RunningServiceContextProvider getRunningServiceContextProvider() {
        return this.runningServiceContextProvider;
    }

    @Inject
    public void setRunningServiceContextProvider(RunningServiceContextProvider runningServiceContextProvider) {
        this.runningServiceContextProvider = runningServiceContextProvider;
    }
}

