/*
 * Decompiled with CFR 0.152.
 */
package org.appops.configuration.guice;

import com.google.inject.Singleton;
import com.google.inject.matcher.AbstractMatcher;
import com.google.inject.matcher.Matcher;
import com.google.inject.matcher.Matchers;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import org.aopalliance.intercept.MethodInterceptor;
import org.appops.configuration.guice.ConfigProvisionInterceptor;
import org.appops.configuration.store.ConfigurationStore;
import org.appops.configuration.store.CurrentRunningServiceContext;
import org.appops.core.CoreModule;
import org.appops.core.annotation.Config;

public class ConfigServiceModule
extends CoreModule {
    public void configure() {
        this.bind(ConfigurationStore.class).in(Singleton.class);
        this.bind(CurrentRunningServiceContext.class).in(Singleton.class);
        ConfigProvisionInterceptor customProvisionListener = new ConfigProvisionInterceptor();
        this.requestInjection(customProvisionListener);
        this.bindInterceptor(Matchers.any(), (Matcher)new ConfigMethodMatcher(), new MethodInterceptor[]{customProvisionListener});
    }

    private final class ConfigMethodMatcher
    extends AbstractMatcher<Method> {
        private ConfigMethodMatcher() {
        }

        public boolean matches(Method method) {
            boolean configInjection = false;
            for (Parameter parameter : method.getParameters()) {
                if (!parameter.isAnnotationPresent(Config.class)) continue;
                configInjection = true;
                break;
            }
            return configInjection && !method.isSynthetic();
        }
    }
}

