/*
 * Decompiled with CFR 0.152.
 */
package org.appops.core.constant;

import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.TreeSet;
import org.appops.core.constant.Constant;

public abstract class IterableConstant<T extends Serializable>
implements Serializable,
Comparable<IterableConstant<T>>,
Constant {
    private T value;
    private static final HashMap<String, TreeSet> types = new HashMap();

    protected IterableConstant(T value) {
        this.value = value;
        this.storeType(this);
    }

    @Override
    public int compareTo(IterableConstant<T> o) {
        T thisValue = this.value();
        T val = o.value();
        if (thisValue instanceof Comparable && val instanceof Comparable) {
            return ((Comparable)thisValue).compareTo(val);
        }
        return 0;
    }

    public T value() {
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeType(IterableConstant constant) {
        TreeSet values;
        String className = constant.getClass().getName();
        HashMap<String, TreeSet> hashMap = types;
        synchronized (hashMap) {
            values = types.computeIfAbsent(className, k -> new TreeSet());
        }
        values.add(constant);
    }

    public boolean equals(Object obj) {
        if (obj instanceof IterableConstant) {
            if (this.value() != null) {
                return this.value().equals(((IterableConstant)obj).value());
            }
            if (((IterableConstant)obj).value() == null) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public Enumeration elements() {
        String className = this.getClass().getName();
        TreeSet values = types.get(className);
        if (values != null) {
            return Collections.enumeration(values);
        }
        return Collections.emptyEnumeration();
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
    }
}

