/*
 * Decompiled with CFR 0.152.
 */
package org.appops.core.service.meta;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.appops.core.annotation.Opinion;
import org.appops.core.service.ExecutionMode;
import org.appops.core.service.ServiceRoute;
import org.appops.core.service.Stage;
import org.appops.core.service.Version;
import org.appops.core.service.meta.InterfaceMeta;

@Opinion(name="service")
public class ServiceMeta {
    private String name;
    private Long id;
    private Set<InterfaceMeta> interfaces = new HashSet<InterfaceMeta>();
    private boolean isDynamic;
    private ServiceRoute route;
    private String dockerFile;
    private Integer deploymentOrder = 0;
    private Version version = Version.defaultVersion();
    private Stage stage = Stage.DEVELOPMENT;
    private ExecutionMode executionMode = ExecutionMode.SERVICE;

    public ServiceMeta() {
    }

    public ServiceMeta(String name) {
        this.setName(name);
    }

    public void addInterface(InterfaceMeta intrfc) {
        this.interfaces.add(intrfc);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public boolean isDynamic() {
        return this.isDynamic;
    }

    public void setDynamic(boolean isDynamic) {
        this.isDynamic = isDynamic;
    }

    public Set<InterfaceMeta> getInterfaces() {
        return this.interfaces;
    }

    public ServiceMeta lightweightCopy() {
        ServiceMeta serviceMeta = new ServiceMeta(this.getName());
        serviceMeta.setId(this.getId());
        serviceMeta.setDynamic(this.isDynamic());
        serviceMeta.setRoute(this.getRoute());
        serviceMeta.setDockerFile(this.getDockerFile());
        return serviceMeta;
    }

    public String contextPath() {
        if (this.getRoute() == null || this.getRoute().getSourceContext() == null) {
            return this.getName();
        }
        return this.getRoute().getSourceContext();
    }

    public ServiceRoute getRoute() {
        return this.route;
    }

    public void setRoute(ServiceRoute route) {
        this.route = route;
    }

    public String getDockerFile() {
        return this.dockerFile;
    }

    public void setDockerFile(String dockerFile) {
        this.dockerFile = dockerFile;
    }

    public Integer getDeploymentOrder() {
        return this.deploymentOrder;
    }

    public void setDeploymentOrder(int deploymentOrder) {
        this.deploymentOrder = deploymentOrder;
    }

    public Version getVersion() {
        return this.version;
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    public Stage getStage() {
        return this.stage;
    }

    public void setStage(Stage stage) {
        this.stage = stage;
    }

    public ExecutionMode getExecutionMode() {
        return this.executionMode;
    }

    public void setExecutionMode(ExecutionMode executionMode) {
        this.executionMode = executionMode;
    }

    public void addInterfaces(Collection<InterfaceMeta> interfaces) {
        this.getInterfaces().addAll(interfaces);
    }
}

