/*
 * Decompiled with CFR 0.152.
 */
package org.appops.core.service.signature;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import org.appops.core.service.annotation.ServiceOp;
import org.appops.core.service.meta.InterfaceMeta;
import org.appops.core.service.meta.ServiceOpMeta;

public class ServiceOpSignatureBuilder {
    public String buildMethodSignature(Class<?> c, Method m) {
        String friendly;
        String signature = "_" + c.getCanonicalName();
        String name = m.getName();
        if (m.isAnnotationPresent(ServiceOp.class) && (friendly = m.getAnnotation(ServiceOp.class).friendly()) != null && !friendly.isEmpty()) {
            name = friendly;
        }
        signature = signature + "_" + name;
        signature = signature + this.getParamSignatures(m.getParameterTypes());
        return signature;
    }

    public String buildOpSignature(ServiceOpMeta opMeta) {
        String signature = "";
        InterfaceMeta interfaceMeta = opMeta.getParent();
        if (interfaceMeta != null) {
            String interfaceName = interfaceMeta.getQualifiedClassName() != null && !interfaceMeta.getQualifiedClassName().isEmpty() ? interfaceMeta.getQualifiedClassName() : interfaceMeta.getName();
            signature = signature + "_" + interfaceName;
        }
        String name = opMeta.getName();
        String friendly = opMeta.getFriendly();
        if (friendly != null && !friendly.isEmpty()) {
            name = friendly;
        }
        signature = signature + "_" + name;
        signature = signature + this.getParamSignatures(opMeta.parameterTypes());
        return signature;
    }

    private String getParamSignatures(Class<?>[] paramTypes) {
        ArrayList<String> typeList = new ArrayList<String>();
        for (Class<?> type : paramTypes) {
            typeList.add(type.getCanonicalName());
        }
        return this.getParamSignatures(typeList);
    }

    private String getParamSignatures(Collection<String> parameterTypes) {
        String paramSig = "";
        for (String typeName : parameterTypes) {
            paramSig = paramSig + "_" + typeName;
        }
        return paramSig;
    }
}

