/*
 * Decompiled with CFR 0.152.
 */
package org.appops.core.store;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.LoadingCache;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.appops.core.exception.CacheException;
import org.appops.core.loader.AppopsCacheLoader;
import org.appops.core.store.Store;

public abstract class CachedStore<K extends Serializable, V extends Serializable>
implements Store<K, V> {
    private LoadingCache<K, V> cache;
    private AppopsCacheLoader<K, V> cacheLoader;

    protected <L extends AppopsCacheLoader<K, V>> CachedStore(L cacheLoader, long maxCacheSize, long expiryTimeInSeconds) {
        this(cacheLoader, maxCacheSize, expiryTimeInSeconds, TimeUnit.SECONDS);
    }

    protected <L extends AppopsCacheLoader<K, V>> CachedStore(L cacheLoader, long maxCacheSize, long expiryTime, TimeUnit expiryTimeUnit) {
        this.setCacheLoader(cacheLoader);
        this.createCache(maxCacheSize, expiryTime, expiryTimeUnit);
    }

    private LoadingCache<K, V> createCache(long maxCacheSize, long expiryTime, TimeUnit expiryTimeUnit) {
        LoadingCache cacheToReturn = CacheBuilder.newBuilder().maximumSize(maxCacheSize).expireAfterAccess(expiryTime, expiryTimeUnit).build(this.getCacheLoader());
        this.setCache(cacheToReturn);
        return cacheToReturn;
    }

    @Override
    public V get(K key) {
        try {
            return (V)((Serializable)this.getCache().get(key));
        }
        catch (Exception e) {
            throw new CacheException(e);
        }
    }

    private void setCache(LoadingCache<K, V> cache) {
        this.cache = cache;
    }

    public AppopsCacheLoader<K, V> getCacheLoader() {
        return this.cacheLoader;
    }

    private void setCacheLoader(AppopsCacheLoader<K, V> cacheLoader) {
        this.cacheLoader = cacheLoader;
    }

    public LoadingCache<K, V> getCache() {
        return this.cache;
    }
}

