/*
 * Decompiled with CFR 0.152.
 */
package org.appops.marshaller.yaml;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import org.appops.marshaller.exception.MarshalException;
import org.appops.marshaller.exception.UnmarshalException;
import org.appops.marshaller.yaml.YamlMarshaller;

public class JacksonYamlMarshaller
implements YamlMarshaller {
    private YAMLMapper mapper = this.createYamlMapper();

    @Override
    public String toYaml(Object instance) {
        try {
            return this.mapper.writeValueAsString(instance).trim();
        }
        catch (JsonProcessingException e) {
            throw new MarshalException(e);
        }
    }

    @Override
    public <T> T fromYaml(String yaml, Class<T> clazz) {
        try {
            return (T)this.mapper.readValue(yaml, clazz);
        }
        catch (JsonProcessingException e) {
            throw new UnmarshalException(e);
        }
    }

    private YAMLMapper createYamlMapper() {
        YAMLMapper mapperToReturn = new YAMLMapper();
        mapperToReturn.enable(SerializationFeature.INDENT_OUTPUT);
        mapperToReturn.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        mapperToReturn.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        mapperToReturn.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        mapperToReturn.enable(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT);
        return mapperToReturn;
    }
}

