/*
 * AppOps is a Java framework to develop, deploy microservices with ease and is available for free
 * and common use developed by AinoSoft ( www.ainosoft.com )
 *
 * AppOps and AinoSoft are registered trademarks of Aino Softwares private limited, India.
 *
 * Copyright (C) <2016> <Aino Softwares private limited>
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the
 * GNU General Public License as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version along with applicable additional terms as
 * provisioned by GPL 3.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License and applicable additional terms
 * along with this program.
 *
 * If not, see <https://www.gnu.org/licenses/> and <https://www.appops.org/license>
 */

package org.appops.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * Scanner which scans details of class e.g. annotated fields, methods, class annotations etc at
 * runtime. e.g. While registering an event listener in appops, this class is used to scan annotated
 * methods to fetch an event type from the class definition of listener.
 *
 * @author deba
 * @version $Id: $Id
 */
public class TypeScanner {


  /**
   * Look for annotated methods present in class.
   *
   * @param type Class to be scanned.
   * @param annotation Annotation to be looked on methods.
   * @return List of annotated methods.
   */
  public List<Method> getAnnotatedMethods(Class<?> type, Class<? extends Annotation> annotation) {

    final List<Method> methods = new ArrayList<>();
    Class<?> klass = type;
    while (klass != Object.class) {
      if (klass == null) {
        break;
      }
      final List<Method> allMethods = new ArrayList<>(Arrays.asList(klass.getDeclaredMethods()));
      for (final Method method : allMethods) {
        if (method.isAnnotationPresent(annotation)) {
          methods.add(method);
        }
      }
      // move to the upper class in the hierarchy in search for more methods
      klass = klass.getSuperclass();
    }
    return methods;
  }


}
