/*
 * AppOps is a Java framework to develop, deploy microservices with ease and is available for free
 * and common use developed by AinoSoft ( www.ainosoft.com )
 *
 * AppOps and AinoSoft are registered trademarks of Aino Softwares private limited, India.
 *
 * Copyright (C) <2016> <Aino Softwares private limited>
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the
 * GNU General Public License as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version along with applicable additional terms as
 * provisioned by GPL 3.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License and applicable additional terms
 * along with this program.
 *
 * If not, see <https://www.gnu.org/licenses/> and <https://www.appops.org/license>
 */

package org.appops.core.deployment;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.File;
import org.appops.configuration.ContainerConfig;
import org.appops.configuration.ModuleConfig;
import org.appops.core.service.ExecutionMode;

/**
 * Represents appops deployment.
 *
 * @author deba
 * @version $Id: $Id
 */
public class ServiceConfiguration {

  private String serviceName;
  private File webappDirectory;
  private String gatewayUrl;
  private Class<?> annotationClass;
  private ExecutionMode executionMode;
  private WebConfig webConfig;
  @JsonIgnore
  private ModuleConfig modules;
  private ContainerConfig containerConfig;
  private JettyConfig jettyConfig;
  private ConfigMap serviceConfig;
  private DeploymentMode mode = DeploymentMode.CLUBBED;
  private String packageToScan;
  private Boolean appopsBlobUpload = true;


  /**
   * Default constructor.
   */
  public ServiceConfiguration() {
    setWebConfig(new WebConfig());
    setGatewayUrl("http://localhost:8080/");
    setContainerConfig(new ContainerConfig(new File("Dockerfile")));
    setModules(new ModuleConfig());
    setWebappDirectory(new File("webapp"));
    setExecutionMode(ExecutionMode.SERVICE);
    setJettyConfig(new JettyConfig());
  }

  public WebConfig getWebConfig() {
    return webConfig;
  }

  public void setWebConfig(WebConfig webConfig) {
    this.webConfig = webConfig;
  }

  /**
   * <p>
   * Constructor for ServiceConfig.
   * </p>
   *
   * @param serviceName a {@link java.lang.String} object.
   */
  public ServiceConfiguration(String serviceName) {
    this();
  }

  /**
   * Object constructor.
   *
   * @param name Service name.
   * @param image Service image path.
   */
  public ServiceConfiguration(String name, String image) {
    this();
  }

  /**
   * <p>
   * Getter for the field <code>annotationClass</code>.
   * </p>
   *
   * @return a {@link java.lang.Class} object.
   */
  public Class<?> getAnnotationClass() {
    return annotationClass;
  }

  /**
   * <p>
   * Setter for the field <code>annotationClass</code>.
   * </p>
   *
   * @param annotationClass a {@link java.lang.Class} object.
   */
  public void setAnnotationClass(Class<?> annotationClass) {
    this.annotationClass = annotationClass;
  }

  /**
   * <p>
   * Getter for the field <code>executionMode</code>.
   * </p>
   *
   * @return a {@link org.appops.core.service.ExecutionMode} object.
   */
  public ExecutionMode getExecutionMode() {
    return executionMode;
  }

  /**
   * <p>
   * Setter for the field <code>executionMode</code>.
   * </p>
   *
   * @param executionMode a {@link org.appops.core.service.ExecutionMode} object.
   */
  public void setExecutionMode(ExecutionMode executionMode) {
    this.executionMode = executionMode;
  }

  /**
   * <p>
   * Getter for the field <code>containerConfig</code>.
   * </p>
   *
   * @return a {@link org.appops.configuration.ContainerConfig} object.
   */
  public ContainerConfig getContainerConfig() {
    return containerConfig;
  }

  /**
   * <p>
   * Setter for the field <code>containerConfig</code>.
   * </p>
   *
   * @param containerConfig a {@link org.appops.configuration.ContainerConfig} object.
   */
  public void setContainerConfig(ContainerConfig containerConfig) {
    this.containerConfig = containerConfig;
  }


  public String getServiceName() {
    return serviceName;
  }

  public void setServiceName(String serviceName) {
    this.serviceName = serviceName;
  }

  public File getWebappDirectory() {
    return webappDirectory;
  }

  public void setWebappDirectory(File webappDirectory) {
    this.webappDirectory = webappDirectory;
  }

  public String getGatewayUrl() {
    return gatewayUrl;
  }

  public void setGatewayUrl(String url) {
    this.gatewayUrl = url;
  }

  public JettyConfig getJettyConfig() {
    return jettyConfig;
  }

  public void setJettyConfig(JettyConfig jettyConfig) {
    this.jettyConfig = jettyConfig;
  }

  public ModuleConfig getModules() {
    return modules;
  }

  public void setModules(ModuleConfig modules) {
    this.modules = modules;
  }

  public ConfigMap getServiceConfig() {
    return serviceConfig;
  }

  public void setServiceConfig(ConfigMap serviceConfig) {
    this.serviceConfig = serviceConfig;
  }

  public void addConfig(String name, Object object) {
    if (getServiceConfig() == null) {
      serviceConfig = new ConfigMap();
    }
    serviceConfig.put(name, object);
  }

  public DeploymentMode getMode() {
    return mode;
  }

  public void setMode(DeploymentMode mode) {
    this.mode = mode;
  }

  public ServiceConfiguration lightweightCopy() {
    ServiceConfiguration serviceConfiguration = new ServiceConfiguration();
    serviceConfiguration.setWebConfig(getWebConfig());
    serviceConfiguration.setMode(getMode());
    serviceConfiguration.setServiceName(getServiceName());
    serviceConfiguration.setAnnotationClass(getAnnotationClass());
    serviceConfiguration.setJettyConfig(getJettyConfig());
    serviceConfiguration.setServiceConfig(getServiceConfig());
    serviceConfiguration.setGatewayUrl(getGatewayUrl());
    serviceConfiguration.setPackageToScan(getPackageToScan());
    serviceConfiguration.setAppopsBlobUpload(getAppopsBlobUpload());
    return serviceConfiguration;
  }

  public String serviceUrl() {
    WebConfig webConfig = getWebConfig();
    return webConfig.getIp() + ":" + webConfig.getPort() + "/" + webConfig.getContextPath();
  }

  /**
   * @return the packageToScan
   */
  public String getPackageToScan() {
    return packageToScan;
  }

  /**
   * @param packageToScan the packageToScan to set
   */
  public void setPackageToScan(String packageToScan) {
    this.packageToScan = packageToScan;
  }

  /**
   * @return the appopsBlobUpload
   */
  public Boolean getAppopsBlobUpload() {
    return appopsBlobUpload;
  }

  /**
   * @param appopsBlobUpload the appopsBlobUpload to set
   */
  public void setAppopsBlobUpload(Boolean appopsBlobUpload) {
    this.appopsBlobUpload = appopsBlobUpload;
  }

}
