/*
 * AppOps is a Java framework to develop, deploy microservices with ease and is available for free
 * and common use developed by AinoSoft ( www.ainosoft.com )
 *
 * AppOps and AinoSoft are registered trademarks of Aino Softwares private limited, India.
 *
 * Copyright (C) <2016> <Aino Softwares private limited>
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the
 * GNU General Public License as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version along with applicable additional terms as
 * provisioned by GPL 3.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License and applicable additional terms
 * along with this program.
 *
 * If not, see <https://www.gnu.org/licenses/> and <https://www.appops.org/license>
 */

package org.appops.core.util;

import org.appops.core.exception.CoreException;

/**
 * <p>DataTypeUtil class.</p>
 *
 * @author deba
 * @version $Id: $Id
 */
public class DataTypeUtil {

  /**
   * Converts java primitive type to its equivalent wrapper type.
   *
   * @param clazz Primitive type.
   * @return Corresponding wrapper type.
   */
  public Class<?> convertPrimitiveToWrapper(Class<?> clazz) {
    if (clazz.equals(boolean.class)) {
      return Boolean.class;
    } else if (clazz.equals(char.class)) {
      return Character.class;
    } else if (clazz.equals(byte.class)) {
      return Byte.class;
    } else if (clazz.equals(short.class)) {
      return Short.class;
    } else if (clazz.equals(int.class)) {
      return Integer.class;
    } else if (clazz.equals(long.class)) {
      return Long.class;
    } else if (clazz.equals(float.class)) {
      return Float.class;
    } else if (clazz.equals(double.class)) {
      return Double.class;
    }
    throw new CoreException("Invalid primitive type ->" + clazz.getCanonicalName());
  }

}
