/*
 * Decompiled with CFR 0.152.
 */
package org.appops.configuration.loader;

import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;
import org.appops.configuration.exception.ConfigurationException;
import org.appops.configuration.slimimpl.SlimImplStructure;
import org.appops.configuration.store.ConfigurationStore;
import org.appops.core.deployment.ConfigMap;
import org.appops.marshaller.DescriptorType;
import org.appops.marshaller.Marshaller;

public class ConfigurationLoader {
    private ConfigurationStore configurationStore;
    private Marshaller marshaller;

    @Inject
    public ConfigurationLoader(ConfigurationStore configurationStore, Marshaller marshaller) {
        this.setConfigurationStore(configurationStore);
        this.setMarshaller(marshaller);
    }

    public void loadConfigurationsFromFile(File file) {
        this.loadConfigurationsFromFile(null, file, false);
    }

    public void loadConfigurationsFromFile(String serviceName, File file) {
        this.loadConfigurationsFromFile(serviceName, file, true);
    }

    private void loadConfigurationsFromFile(String serviceName, File file, boolean isServiceNameExpected) {
        if (isServiceNameExpected && (serviceName == null || serviceName.isEmpty())) {
            throw new ConfigurationException("Use another method(a method without service name parameter) to load configuration.");
        }
        DescriptorType descriptorType = DescriptorType.fromExtension(file.getName());
        try {
            String marshalledData = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
            SlimImplStructure slimImpConfig = this.getMarshaller().unmarshall(marshalledData, SlimImplStructure.class, descriptorType);
            ConfigMap configMap = slimImpConfig.getConfig();
            if (configMap != null && !configMap.isEmpty()) {
                for (String key : configMap.keySet()) {
                    if (key == null) continue;
                    String configJson = this.getMarshaller().marshall(configMap.get(key), DescriptorType.YML);
                    this.getConfigurationStore().addConfiguration(serviceName, key, configJson);
                }
            }
        }
        catch (IOException e) {
            throw new ConfigurationException(e);
        }
    }

    public ConfigurationStore getConfigurationStore() {
        return this.configurationStore;
    }

    private void setConfigurationStore(ConfigurationStore configurationStore) {
        this.configurationStore = configurationStore;
    }

    public Marshaller getMarshaller() {
        return this.marshaller;
    }

    @Inject
    public void setMarshaller(Marshaller marshaller) {
        this.marshaller = marshaller;
    }
}

