/*
 * AppOps is a Java framework to develop, deploy microservices with ease and is available for free
 * and common use developed by AinoSoft ( www.ainosoft.com )
 *
 * AppOps and AinoSoft are registered trademarks of Aino Softwares private limited, India.
 *
 * Copyright (C) <2016> <Aino Softwares private limited>
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the
 * GNU General Public License as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version along with applicable additional terms as
 * provisioned by GPL 3.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License and applicable additional terms
 * along with this program.
 *
 * If not, see <https://www.gnu.org/licenses/> and <https://www.appops.org/license>
 */

package org.appops.configuration;

import com.google.common.base.Preconditions;
import java.io.File;

/**
 * Service container configuration. To be used while deploying service application inside docker
 * environment.
 *
 * @author deba
 * @version $Id: $Id
 */
public class ContainerConfig {


  private File dockerFileOrBaseDirectory;

  /**
   * <p>Constructor for ContainerConfig.</p>
   */
  public ContainerConfig() {

  }


  /**
   * <p>Constructor for ContainerConfig.</p>
   *
   * @param dockerFileOrBaseDirectory a {@link java.io.File} object.
   */
  public ContainerConfig(File dockerFileOrBaseDirectory) {
    withDockerFileOrBaseDirectory(dockerFileOrBaseDirectory);
  }


  /**
   * Creates container configuration using either container directory or docker file.
   *
   * @param dockerFileOrBaseDirectory A configuration configuration which can be either container
   *        base directory in which container configuration is stored or a dockerfile for container
   *        configuration.
   * @return Updated container configuration.
   */
  public ContainerConfig withDockerFileOrBaseDirectory(File dockerFileOrBaseDirectory) {
    Preconditions.checkNotNull(dockerFileOrBaseDirectory,
        "Null value passed for DockerFile Or BaseDirectory in docker configuration.");
    Preconditions.checkArgument(dockerFileOrBaseDirectory.exists(),
        "DockerFile Or BaseDirectory does not exist. path -> "
            + dockerFileOrBaseDirectory.getPath());
    setDockerFileOrBaseDirectory(dockerFileOrBaseDirectory);
    return this;
  }

  /**
   * <p>Getter for the field <code>dockerFileOrBaseDirectory</code>.</p>
   *
   * @return a {@link java.io.File} object.
   */
  public File getDockerFileOrBaseDirectory() {
    return dockerFileOrBaseDirectory;
  }

  private void setDockerFileOrBaseDirectory(File dockerFileOrBaseDirectory) {
    this.dockerFileOrBaseDirectory = dockerFileOrBaseDirectory;
  }

}
