/*
 * AppOps is a Java framework to develop, deploy microservices with ease and is available for free
 * and common use developed by AinoSoft ( www.ainosoft.com )
 *
 * AppOps and AinoSoft are registered trademarks of Aino Softwares private limited, India.
 *
 * Copyright (C) <2016> <Aino Softwares private limited>
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the
 * GNU General Public License as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version along with applicable additional terms as
 * provisioned by GPL 3.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License and applicable additional terms
 * along with this program.
 *
 * If not, see <https://www.gnu.org/licenses/> and <https://www.appops.org/license>
 */

package org.appops.configuration.generator;

import com.google.inject.Guice;
import com.google.inject.Injector;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;
import org.appops.configuration.guice.ConfigServiceModule;
import org.appops.marshaller.guice.MarshallerModule;

/**
 * <p>ConfigGenerator class.</p>
 *
 * @author deba
 * @version $Id: $Id
 */
public class ConfigGenerator {

  /**
   * An entry point method for configuration generation utility.
   *
   * @param args Array of arguments.
   * @throws java.io.IOException if any.
   */
  public static void main(String[] args) throws IOException {
    if (args.length <= 0) {
      System.out.println("Please provide configuration file...!!!");
      return;
    }

    String configFile = args[0];
    Injector injector = Guice.createInjector(new ConfigServiceModule(), new MarshallerModule());
    String json = injector.getInstance(ConfigJsonGenerator.class).generateConfiguration();
    FileUtils.writeStringToFile(new File(configFile), json, StandardCharsets.UTF_8);
    
  }
}
