/*
 * AppOps is a Java framework to develop, deploy microservices with ease and is available for free
 * and common use developed by AinoSoft ( www.ainosoft.com )
 *
 * AppOps and AinoSoft are registered trademarks of Aino Softwares private limited, India.
 *
 * Copyright (C) <2016> <Aino Softwares private limited>
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the
 * GNU General Public License as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version along with applicable additional terms as
 * provisioned by GPL 3.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License and applicable additional terms
 * along with this program.
 *
 * If not, see <https://www.gnu.org/licenses/> and <https://www.appops.org/license>
 */

package org.appops.configuration.slimimpl;

import com.google.inject.Module;
import java.util.HashSet;
import java.util.Set;
import org.appops.core.annotation.Config;
import org.appops.core.deployment.ConfigMap;

/**
 * Configuration File structure which contains modules ,{@link Config} classes.
 * 
 * @author prashant
 *
 */
public class SlimImplStructure {

  private String annotationClass;
  private ConfigMap config;
  private Set<Class<? extends Module>> modules;

  public SlimImplStructure() {
    config = new ConfigMap();
    modules = new HashSet<>();
  }

  /**
   * @return the config
   */
  public ConfigMap getConfig() {
    if (config == null) {
      setConfig(new ConfigMap());
    }
    return config;
  }

  /**
   * @param config the config to set
   */
  public void setConfig(ConfigMap config) {
    this.config = config;
  }

  /**
   * @return the modules
   */
  public Set<Class<? extends Module>> getModules() {
    return modules;
  }

  /**
   * @param modules the modules to set
   */
  public void setModules(Set<Class<? extends Module>> modules) {
    this.modules = modules;
  }

  /**
   * @param module the modules to set
   */

  public void addModule(Class<? extends Module> module) {
    if (getModules() == null) {
      setModules(new HashSet<>());
    }
    getModules().add(module);
  }

  /**
   * @return the annotation
   */
  public String getAnnotationClass() {
    return annotationClass;
  }

  /**
   * @param annotationClass the annotation to set
   * @return this.
   */
  public SlimImplStructure setAnnotationClass(String annotationClass) {
    this.annotationClass = annotationClass;
    return this;
  }

}
