/*
 * AppOps is a Java framework to develop, deploy microservices with ease and is available for free
 * and common use developed by AinoSoft ( www.ainosoft.com )
 *
 * AppOps and AinoSoft are registered trademarks of Aino Softwares private limited, India.
 *
 * Copyright (C) <2016> <Aino Softwares private limited>
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the
 * GNU General Public License as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version along with applicable additional terms as
 * provisioned by GPL 3.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License and applicable additional terms
 * along with this program.
 *
 * If not, see <https://www.gnu.org/licenses/> and <https://www.appops.org/license>
 */

package org.appops.core.job;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/**
 * <p>Abstract JobBase class.</p>
 *
 * @author deba
 * @version $Id: $Id
 */
public abstract class JobBase<R> {
  private Map<String, Serializable> parameters = new HashMap<>();

  /**
   * <p>execute.</p>
   *
   * @return a R object.
   */
  public abstract R execute();

  /**
   * <p>Getter for the field <code>parameters</code>.</p>
   *
   * @return a {@link java.util.Map} object.
   */
  public Map<String, Serializable> getParameters() {
    return parameters;
  }

  /**
   * <p>Setter for the field <code>parameters</code>.</p>
   *
   * @param parameters a {@link java.util.Map} object.
   */
  public void setParameters(Map<String, Serializable> parameters) {
    this.parameters = parameters;
  }

  /**
   * <p>addParameter.</p>
   *
   * @param name a {@link java.lang.String} object.
   * @param value a {@link java.io.Serializable} object.
   */
  public void addParameter(String name, Serializable value) {
    getParameters().put(name, value);
  }

  /**
   * <p>getParameter.</p>
   *
   * @param name a {@link java.lang.String} object.
   * @return a {@link java.io.Serializable} object.
   */
  public Serializable getParameter(String name) {
    return getParameters().get(name);
  }
}
