/*
 * AppOps is a Java framework to develop, deploy microservices with ease and is available for free
 * and common use developed by AinoSoft ( www.ainosoft.com )
 *
 * AppOps and AinoSoft are registered trademarks of Aino Softwares private limited, India.
 *
 * Copyright (C) <2016> <Aino Softwares private limited>
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the
 * GNU General Public License as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version along with applicable additional terms as
 * provisioned by GPL 3.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License and applicable additional terms
 * along with this program.
 *
 * If not, see <https://www.gnu.org/licenses/> and <https://www.appops.org/license>
 */
package org.appops.core.job.token;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.appops.core.GuidGenerator;

/**
 * A token that descibes the jobs. It contains meta information required for job execution.
 *
 * @author deba
 * @version $Id: $Id
 */
public class JobToken {
  private Double jobAffinity;
  private String jobClassName;
  private String serviceName;
  private Map<String, Serializable> parameters = new HashMap<>();
  private String scheduleExpression;
  private TokenType tokenType = TokenType.PLAIN;
  private String guid;
  private JobTokenInputInfo jobTokenInputInfo;

  /**
   * Default constructor where guid is generated using {@link org.appops.core.GuidGenerator}.
   */
  public JobToken() {
    setGuid(GuidGenerator.get(12).toString());
  }

  /**
   * <p>Getter for the field <code>scheduleExpression</code>.</p>
   *
   * @return a {@link java.lang.String} object.
   */
  public String getScheduleExpression() {
    return scheduleExpression;
  }

  /**
   * Schedule expression to execute job token on.
   *
   * @param scheduleExpression cron expression
   */
  public void setScheduleExpression(String scheduleExpression) {
    this.scheduleExpression = scheduleExpression;
    setTokenType(TokenType.SCHEDULE);
  }

  /**
   * <p>addParameter.</p>
   *
   * @param name a {@link java.lang.String} object.
   * @param value a {@link java.io.Serializable} object.
   */
  public void addParameter(String name, Serializable value) {
    getParameters().put(name, value);
  }

  /**
   * <p>Getter for the field <code>jobAffinity</code>.</p>
   *
   * @return a {@link java.lang.Double} object.
   */
  public Double getJobAffinity() {
    return jobAffinity;
  }

  /**
   * <p>Setter for the field <code>jobAffinity</code>.</p>
   *
   * @param jobAffinity a {@link java.lang.Double} object.
   */
  public void setJobAffinity(Double jobAffinity) {
    this.jobAffinity = jobAffinity;
  }

  /**
   * <p>Getter for the field <code>jobClassName</code>.</p>
   *
   * @return a {@link java.lang.String} object.
   */
  public String getJobClassName() {
    return jobClassName;
  }

  /**
   * <p>Setter for the field <code>jobClassName</code>.</p>
   *
   * @param jobClassName a {@link java.lang.String} object.
   */
  public void setJobClassName(String jobClassName) {
    this.jobClassName = jobClassName;
  }

  /**
   * <p>getParameter.</p>
   *
   * @param parameterName a {@link java.lang.String} object.
   * @return a {@link java.io.Serializable} object.
   */
  public Serializable getParameter(String parameterName) {
    return getParameters().get(parameterName);
  }

  /**
   * <p>Getter for the field <code>parameters</code>.</p>
   *
   * @return a {@link java.util.Map} object.
   */
  public Map<String, Serializable> getParameters() {
    return parameters;
  }

  /**
   * <p>Setter for the field <code>parameters</code>.</p>
   *
   * @param parameters a {@link java.util.Map} object.
   */
  public void setParameters(Map<String, Serializable> parameters) {
    this.parameters = parameters;
  }

  /**
   * <p>Getter for the field <code>serviceName</code>.</p>
   *
   * @return a {@link java.lang.String} object.
   */
  public String getServiceName() {
    return serviceName;
  }

  /**
   * <p>Setter for the field <code>serviceName</code>.</p>
   *
   * @param serviceName a {@link java.lang.String} object.
   */
  public void setServiceName(String serviceName) {
    this.serviceName = serviceName;
  }

  /**
   * Build job key to identify job uniquely.
   *
   * @return unique job key.
   */
  public String getJobKey() {
    return getJobClassName();
  }

  /**
   * <p>Getter for the field <code>tokenType</code>.</p>
   *
   * @return a {@link org.appops.core.job.token.TokenType} object.
   */
  public TokenType getTokenType() {
    return tokenType;
  }

  /**
   * <p>Setter for the field <code>tokenType</code>.</p>
   *
   * @param tokenType a {@link org.appops.core.job.token.TokenType} object.
   */
  public void setTokenType(TokenType tokenType) {
    this.tokenType = tokenType;
  }

  /**
   * <p>Getter for the field <code>guid</code>.</p>
   *
   * @return a {@link java.lang.String} object.
   */
  public String getGuid() {
    return guid;
  }

  /**
   * <p>Setter for the field <code>guid</code>.</p>
   *
   * @param guid a {@link java.lang.String} object.
   */
  public void setGuid(String guid) {
    this.guid = guid;
  }

  /**
   * <p>Getter for the field <code>jobTokenInputInfo</code>.</p>
   *
   * @return a {@link org.appops.core.job.token.JobTokenInputInfo} object.
   */
  public JobTokenInputInfo getJobTokenInputInfo() {
    return jobTokenInputInfo;
  }

  /**
   * <p>Setter for the field <code>jobTokenInputInfo</code>.</p>
   *
   * @param jobTokenInputInfo a {@link org.appops.core.job.token.JobTokenInputInfo} object.
   */
  public void setJobTokenInputInfo(JobTokenInputInfo jobTokenInputInfo) {
    this.jobTokenInputInfo = jobTokenInputInfo;
  }

}
