/*
 * AppOps is a Java framework to develop, deploy microservices with ease and is available for free
 * and common use developed by AinoSoft ( www.ainosoft.com )
 *
 * AppOps and AinoSoft are registered trademarks of Aino Softwares private limited, India.
 *
 * Copyright (C) <2016> <Aino Softwares private limited>
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the
 * GNU General Public License as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version along with applicable additional terms as
 * provisioned by GPL 3.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License and applicable additional terms
 * along with this program.
 *
 * If not, see <https://www.gnu.org/licenses/> and <https://www.appops.org/license>
 */

package org.appops.core.mime;

import org.appops.core.constant.IterableConstant;

/**
 * Constant declaring mime types available in appops.
 *
 * @author deba
 * @version $Id: $Id
 */
public class MimeType extends IterableConstant<String> {

  private MimeType(String value) {
    super(value);
  }


  /** Constant <code>XML</code> */
  public static final MimeType XML = new MimeType("text/xml");
  /** Constant <code>JSON</code> */
  public static final MimeType JSON = new MimeType("application/json");
  /** Constant <code>TEXT</code> */
  public static final MimeType TEXT = new MimeType("text/plain");
  /** Constant <code>JPEG</code> */
  public static final MimeType JPEG = new MimeType("image/jpeg");
  /** Constant <code>MULTIPART</code> */
  public static final MimeType MULTIPART = new MimeType("multipart/form-data");
  /** Constant <code>FORM_URL_ENCODED</code> */
  public static final MimeType FORM_URL_ENCODED = new MimeType("application/x-www-form-urlencoded");
  /** Constant <code>BLOB</code> */
  public static final MimeType BLOB = new MimeType("BLOB");

}
