/*
 * AppOps is a Java framework to develop, deploy microservices with ease and is available for free
 * and common use developed by AinoSoft ( www.ainosoft.com )
 *
 * AppOps and AinoSoft are registered trademarks of Aino Softwares private limited, India.
 *
 * Copyright (C) <2016> <Aino Softwares private limited>
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the
 * GNU General Public License as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version along with applicable additional terms as
 * provisioned by GPL 3.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License and applicable additional terms
 * along with this program.
 *
 * If not, see <https://www.gnu.org/licenses/> and <https://www.appops.org/license>
 */
package org.appops.core.response;

import java.io.Serializable;

/**
 * A class contains Blob input stream and mime type.
 *
 * @author deba
 * @version $Id: $Id
 */
public class BlobResponse implements Serializable {

	/**
	 * 
	 */
  private Byte[] byteArray;
  
  /**
   * 
   */
  private String mimeType;
  
  /**
   * 
   */
  private String fileName;

  /**
   * <p>Constructor for BlobResponse.</p>
   */
  public BlobResponse() {

  }

  /**
   * <p>Getter for the field <code>byteArray</code>.</p>
   *
   * @return an array of {@link java.lang.Byte} objects.
   */
  public Byte[] getByteArray() {
    return byteArray;
  }

  /**
   * <p>Setter for the field <code>byteArray</code>.</p>
   *
   * @param byteArray an array of {@link java.lang.Byte} objects.
   */
  public void setByteArray(Byte[] byteArray) {
    this.byteArray = byteArray;
  }

  /**
   * <p>Getter for the field <code>mimeType</code>.</p>
   *
   * @return a {@link java.lang.String} object.
   */
  public String getMimeType() {
    return mimeType;
  }

  /**
   * <p>Setter for the field <code>mimeType</code>.</p>
   *
   * @param mimeType a {@link java.lang.String} object.
   */
  public void setMimeType(String mimeType) {
    this.mimeType = mimeType;
  }

  /**
   * <p>Getter for the field <code>fileName</code>.</p>
   *
   * @return a {@link java.lang.String} object.
   */
  public String getFileName() {
    return fileName;
  }

  /**
   * <p>Setter for the field <code>fileName</code>.</p>
   *
   * @param fileName a {@link java.lang.String} object.
   */
  public void setFileName(String fileName) {
    this.fileName = fileName;
  }


}
